/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.jcckit;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.PSystemBasicFactory;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.core.DiagramType;
import znaishaded.net.sourceforge.plantuml.jcckit.PSystemJcckit;

public class PSystemJcckitFactory
extends PSystemBasicFactory<PSystemJcckit> {
    private StringBuilder data;
    private int width;
    private int height;

    public PSystemJcckitFactory(DiagramType diagramType) {
        super(diagramType);
    }

    @Override
    public PSystemJcckit init(String startLine) {
        this.data = null;
        this.width = 640;
        this.height = 400;
        if (this.getDiagramType() == DiagramType.UML) {
            return null;
        }
        if (this.getDiagramType() == DiagramType.JCCKIT) {
            this.extractDimension(startLine);
            this.data = new StringBuilder();
            return this.createSystem();
        }
        throw new IllegalStateException(this.getDiagramType().name());
    }

    private void extractDimension(String startLine) {
        Pattern2 p = MyPattern.cmpile("\\((\\d+),(\\d+)\\)");
        Matcher2 m3 = p.matcher(startLine);
        boolean ok = m3.find();
        if (ok) {
            this.width = Integer.parseInt(m3.group(1));
            this.height = Integer.parseInt(m3.group(2));
        }
    }

    String getDimension() {
        return "" + this.width + "-" + this.height;
    }

    private PSystemJcckit createSystem() {
        Properties p = new Properties();
        try {
            p.load(new StringReader(this.data.toString()));
        }
        catch (IOException e) {
            Log.error("Error " + e);
            e.printStackTrace();
            return null;
        }
        return new PSystemJcckit(p, this.width, this.height);
    }

    @Override
    public PSystemJcckit executeLine(PSystemJcckit system, String line) {
        if (system == null && line.startsWith("jcckit")) {
            this.data = new StringBuilder();
            this.extractDimension(line);
            return this.createSystem();
        }
        if (this.data == null) {
            return null;
        }
        this.data.append(StringUtils.trin(line));
        this.data.append("\n");
        return this.createSystem();
    }
}

