/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.objectdiagram.command;

import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodierMap;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Ident;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkDecor;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

public class CommandCreateMap
extends CommandMultilines2<AbstractClassOrObjectDiagram> {
    public CommandCreateMap() {
        super(CommandCreateMap.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateMap.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "map"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "(?:[%g]([^%g]+)[%g][%s]+as[%s]+)?([\\p{L}0-9_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^[%s]*\\}[%s]*$";
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractClassOrObjectDiagram diagram, BlocLines lines) {
        lines = lines.trim().removeEmptyLines();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        IEntity entity1 = this.executeArg0(diagram, line0);
        if (entity1 == null) {
            return CommandExecutionResult.error("No such entity");
        }
        lines = lines.subExtract(1, 1);
        for (StringLocated sl : lines) {
            String line = sl.getString();
            assert (line.length() > 0);
            entity1.getBodier().addFieldOrMethod(line);
            if (BodierMap.getLinkedEntry(line) == null) continue;
            String linkStr = BodierMap.getLinkedEntry(line);
            int x = line.indexOf(linkStr);
            String key = line.substring(0, x).trim();
            String dest = line.substring(x + linkStr.length()).trim();
            Ident ident2 = diagram.buildLeafIdentSpecial(dest);
            ILeaf entity2 = diagram.getEntityFactory().getLeafStrict(ident2);
            LinkType linkType = new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
            int length = linkStr.length() - 2;
            Link link = new Link(entity1, entity2, linkType, Display.NULL, length, diagram.getSkinParam().getCurrentStyleBuilder());
            link.setPortMembers(key, null);
            diagram.addLink(link);
        }
        return CommandExecutionResult.ok();
    }

    private IEntity executeArg0(AbstractClassOrObjectDiagram diagram, RegexResult line0) {
        boolean leafExist;
        String name = line0.get("NAME", 1);
        Ident ident = diagram.buildLeafIdent(name);
        Ident code = diagram.V1972() ? ident : diagram.buildCode(name);
        String display = line0.get("NAME", 0);
        String stereotype = line0.get("STEREO", 0);
        boolean bl = leafExist = diagram.V1972() ? diagram.leafExistSmart(ident) : diagram.leafExist(code);
        if (leafExist) {
            return diagram.getOrCreateLeaf(diagram.buildLeafIdent(name), code, LeafType.MAP, null);
        }
        ILeaf entity = diagram.createLeaf(ident, code, Display.getWithNewlines(display), LeafType.MAP, null);
        if (stereotype != null) {
            entity.setStereotype(new Stereotype(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(line0.get("COLOR", 0)));
        return entity;
    }
}

