/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.timescale;

import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.DayOfWeek;
import znaishaded.net.sourceforge.plantuml.project.time.GCalendar;
import znaishaded.net.sourceforge.plantuml.project.time.Wink;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScale;

public class UnusedTimeScaleWithoutWeekEnd
implements TimeScale {
    private final double scale = 16.0;
    private final GCalendar calendar;

    public UnusedTimeScaleWithoutWeekEnd(GCalendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException();
        }
        this.calendar = calendar;
    }

    @Override
    public double getStartingPosition(Wink instant) {
        double result = 0.0;
        Wink current = instant;
        while (current.getWink() > 0) {
            current = current.decrement();
            result += this.getWidth(current);
        }
        return result;
    }

    @Override
    public double getWidth(Wink instant) {
        Day day = this.calendar.toDayAsDate(instant);
        DayOfWeek dayOfWeek = day.getDayOfWeek();
        if (dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) {
            return 1.0;
        }
        return 16.0;
    }

    @Override
    public double getEndingPosition(Wink instant) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBreaking(Wink instant) {
        throw new UnsupportedOperationException();
    }
}

