/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.png.PngTitler;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class SequenceDiagramArea {
    private final double sequenceWidth;
    private final double sequenceHeight;
    private double headerWidth;
    private double headerHeight;
    private double headerMargin;
    private double titleWidth;
    private double titleHeight;
    private double captionWidth;
    private double captionHeight;
    private double footerWidth;
    private double footerHeight;
    private double footerMargin;

    public SequenceDiagramArea(double width, double height) {
        this.sequenceWidth = width;
        this.sequenceHeight = height;
    }

    public void setTitleArea(double width, double height) {
        this.titleWidth = width;
        this.titleHeight = height;
    }

    private void setCaptionArea(double width, double height) {
        this.captionWidth = width;
        this.captionHeight = height;
    }

    public void setCaptionArea(Dimension2D dim) {
        this.setCaptionArea(dim.getWidth(), dim.getHeight());
    }

    public void setHeaderArea(double headerWidth, double headerHeight, double headerMargin) {
        this.headerWidth = headerWidth;
        this.headerHeight = headerHeight;
        this.headerMargin = headerMargin;
    }

    public void setFooterArea(double footerWidth, double footerHeight, double footerMargin) {
        this.footerWidth = footerWidth;
        this.footerHeight = footerHeight;
        this.footerMargin = footerMargin;
    }

    public double getWidth() {
        return MathUtils.max(this.sequenceWidth, this.headerWidth, this.titleWidth, this.footerWidth, this.captionWidth);
    }

    public double getHeight() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight + this.footerMargin + this.footerHeight + this.captionHeight;
    }

    public double getTitleX() {
        return (this.getWidth() - this.titleWidth) / 2.0;
    }

    public double getTitleY() {
        return this.headerHeight + this.headerMargin;
    }

    public double getHeaderHeightMargin() {
        return this.headerHeight + this.headerMargin;
    }

    public double getCaptionX() {
        return (this.getWidth() - this.captionWidth) / 2.0;
    }

    public double getCaptionY() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight;
    }

    public double getSequenceAreaX() {
        return (this.getWidth() - this.sequenceWidth) / 2.0;
    }

    public double getSequenceAreaY() {
        return this.getTitleY() + this.titleHeight;
    }

    public double getHeaderY() {
        return 0.0;
    }

    public double getFooterY() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight + this.footerMargin + this.captionHeight;
    }

    public double getFooterX(HorizontalAlignment align) {
        if (align == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (align == HorizontalAlignment.RIGHT) {
            return this.getWidth() - this.footerWidth;
        }
        if (align == HorizontalAlignment.CENTER) {
            return (this.getWidth() - this.footerWidth) / 2.0;
        }
        throw new IllegalStateException();
    }

    public double getHeaderX(HorizontalAlignment align) {
        if (align == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (align == HorizontalAlignment.RIGHT) {
            return this.getWidth() - this.headerWidth;
        }
        if (align == HorizontalAlignment.CENTER) {
            return (this.getWidth() - this.headerWidth) / 2.0;
        }
        throw new IllegalStateException();
    }

    public void initFooter(PngTitler pngTitler, StringBounder stringBounder) {
        Dimension2D dim = pngTitler.getTextDimension(stringBounder);
        if (dim != null) {
            if (SkinParam.USE_STYLES()) {
                this.setFooterArea(dim.getWidth(), dim.getHeight(), 0.0);
            } else {
                this.setFooterArea(dim.getWidth(), dim.getHeight(), 3.0);
            }
        }
    }

    public void initHeader(PngTitler pngTitler, StringBounder stringBounder) {
        Dimension2D dim = pngTitler.getTextDimension(stringBounder);
        if (dim != null) {
            if (SkinParam.USE_STYLES()) {
                this.setHeaderArea(dim.getWidth(), dim.getHeight(), 0.0);
            } else {
                this.setHeaderArea(dim.getWidth(), dim.getHeight(), 3.0);
            }
        }
    }
}

