/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.real.RealUtils;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Grouping;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingStart;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.ElseTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EmptyTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LifeEventTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxFinder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.NewpageTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileBuilder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileParallel;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.YPositionedTile;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class GroupingTile
extends AbstractTile
implements TileWithCallbackY {
    private static final int EXTERNAL_MARGINX1 = 3;
    private static final int EXTERNAL_MARGINX2 = 9;
    private static final int MARGINX = 16;
    private static final int MARGINY = 10;
    private List<Tile> tiles = new ArrayList<Tile>();
    private final Real min;
    private final Real max;
    private final GroupingStart start;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Display display;
    private double bodyHeight;
    private double y;

    @Override
    public Event getEvent() {
        return this.start;
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        return 0.0;
    }

    public GroupingTile(Iterator<Event> it, GroupingStart start, TileArguments tileArgumentsBachColorChanged, TileArguments tileArgumentsOriginal) {
        Object ev;
        StringBounder stringBounder = tileArgumentsOriginal.getStringBounder();
        this.start = start;
        this.display = start.getTitle().equals("group") ? Display.create(start.getComment()) : Display.create(start.getTitle(), start.getComment());
        this.skin = tileArgumentsOriginal.getSkin();
        this.skinParam = tileArgumentsBachColorChanged.getSkinParam();
        ArrayList<Real> min2 = new ArrayList<Real>();
        ArrayList<Real> max2 = new ArrayList<Real>();
        ArrayList<Tile> allElses = new ArrayList<Tile>();
        while (it.hasNext() && (!((ev = it.next()) instanceof GroupingLeaf) || ((Grouping)ev).getType() != GroupingType.END)) {
            for (Tile tile : TileBuilder.buildOne(it, tileArgumentsOriginal, (Event)ev, this)) {
                this.tiles.add(tile);
            }
        }
        this.tiles = GroupingTile.mergeParallel(this.tiles);
        for (Tile tile : this.tiles) {
            this.bodyHeight += tile.getPreferredHeight(stringBounder);
            Event ev2 = tile.getEvent();
            if (ev2 instanceof GroupingLeaf && ((Grouping)ev2).getType() == GroupingType.ELSE) {
                allElses.add(tile);
                continue;
            }
            min2.add(tile.getMinX(stringBounder).addFixed(-16.0));
            Real m3 = tile.getMaxX(stringBounder);
            max2.add(m3.addFixed(16.0));
        }
        Dimension2D dim1 = this.getPreferredDimensionIfEmpty(stringBounder);
        double width = dim1.getWidth();
        if (min2.size() == 0) {
            min2.add(tileArgumentsOriginal.getOrigin());
        }
        this.min = RealUtils.min(min2);
        for (Tile anElse : allElses) {
            max2.add(anElse.getMaxX(stringBounder));
        }
        max2.add(this.min.addFixed(width + 16.0));
        this.max = RealUtils.max(max2);
    }

    private Component getComponent(StringBounder stringBounder) {
        Component comp = this.skin.createComponent(this.start.getUsedStyles(), ComponentType.GROUPING_HEADER, null, this.skinParam, this.display);
        return comp;
    }

    private Dimension2D getPreferredDimensionIfEmpty(StringBounder stringBounder) {
        return this.getComponent(stringBounder).getPreferredDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim1 = this.getPreferredDimensionIfEmpty(stringBounder);
        Area area = new Area(this.max.getCurrentValue() - this.min.getCurrentValue(), this.getTotalHeight(stringBounder));
        if (!(ug instanceof LiveBoxFinder)) {
            comp.drawU(ug.apply(UTranslate.dx(this.min.getCurrentValue())), area, (Context2D)((Object)ug));
            this.drawAllElses(ug);
        }
        double h2 = dim1.getHeight() + 5.0;
        for (Tile tile : this.tiles) {
            ug.apply(UTranslate.dy(h2)).draw(tile);
            double preferredHeight = tile.getPreferredHeight(stringBounder);
            h2 += preferredHeight;
        }
    }

    private double getTotalHeight(StringBounder stringBounder) {
        Dimension2D dimIfEmpty = this.getPreferredDimensionIfEmpty(stringBounder);
        return this.bodyHeight + dimIfEmpty.getHeight() + 5.0;
    }

    private void drawAllElses(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        double totalHeight = this.getTotalHeight(stringBounder);
        ArrayList<Double> ys = new ArrayList<Double>();
        for (Tile tile : this.tiles) {
            if (!(tile instanceof ElseTile)) continue;
            ElseTile elseTile = (ElseTile)tile;
            ys.add(elseTile.getCallbackY() - this.y + 5.0);
        }
        ys.add(totalHeight);
        int i = 0;
        for (Tile tile : this.tiles) {
            if (!(tile instanceof ElseTile)) continue;
            ElseTile elseTile = (ElseTile)tile;
            Component comp = elseTile.getComponent(stringBounder);
            Area area = new Area(this.max.getCurrentValue() - this.min.getCurrentValue(), (Double)ys.get(i + 1) - (Double)ys.get(i));
            comp.drawU(ug.apply(new UTranslate(this.min.getCurrentValue(), (Double)ys.get(i))), area, (Context2D)((Object)ug));
            ++i;
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dim1 = this.getPreferredDimensionIfEmpty(stringBounder);
        return dim1.getHeight() + this.bodyHeight + 10.0;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        for (Tile tile : this.tiles) {
            tile.addConstraints(stringBounder);
        }
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.min.addFixed(-3.0);
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return this.max.addFixed(9.0);
    }

    @Override
    public void callbackY(double y) {
        this.y = y;
    }

    public static double fillPositionelTiles(StringBounder stringBounder, double y, List<Tile> tiles, List<YPositionedTile> local, List<YPositionedTile> full) {
        for (Tile tile : GroupingTile.mergeParallel(tiles)) {
            YPositionedTile ytile = new YPositionedTile(tile, y);
            local.add(ytile);
            full.add(ytile);
            if (tile instanceof GroupingTile) {
                GroupingTile groupingTile = (GroupingTile)tile;
                double headerHeight = groupingTile.getHeaderHeight(stringBounder);
                ArrayList<YPositionedTile> local2 = new ArrayList<YPositionedTile>();
                GroupingTile.fillPositionelTiles(stringBounder, y + headerHeight, groupingTile.tiles, local2, full);
            }
            y += tile.getPreferredHeight(stringBounder);
        }
        return y;
    }

    private double getHeaderHeight(StringBounder stringBounder) {
        return this.getPreferredDimensionIfEmpty(stringBounder).getHeight() + 10.0;
    }

    private static List<Tile> mergeParallel(List<Tile> tiles) {
        TileParallel pending = null;
        tiles = GroupingTile.removeEmptyCloseToParallel(tiles);
        ArrayList<Tile> result = new ArrayList<Tile>();
        for (Tile tile : tiles) {
            if (GroupingTile.isParallel(tile)) {
                if (pending == null) {
                    pending = new TileParallel();
                    Tile tmp = (Tile)result.get(result.size() - 1);
                    if (tmp instanceof LifeEventTile) {
                        pending.add((Tile)result.get(result.size() - 2));
                        pending.add(tmp);
                        result.set(result.size() - 2, pending);
                        result.remove(result.size() - 1);
                    } else {
                        pending.add(tmp);
                        result.set(result.size() - 1, pending);
                    }
                }
                pending.add(tile);
                continue;
            }
            result.add(tile);
            pending = null;
        }
        return result;
    }

    private static List<Tile> removeEmptyCloseToParallel(List<Tile> tiles) {
        ArrayList<Tile> result = new ArrayList<Tile>();
        for (Tile tile : tiles) {
            if (GroupingTile.isParallel(tile)) {
                GroupingTile.removeHeadEmpty(result);
            }
            result.add(tile);
        }
        return result;
    }

    private static void removeHeadEmpty(List<Tile> tiles) {
        while (tiles.size() > 0 && tiles.get(tiles.size() - 1) instanceof EmptyTile) {
            tiles.remove(tiles.size() - 1);
        }
    }

    private static boolean isParallel(Tile tile) {
        return !(tile instanceof TileParallel) && tile.getEvent().isParallel();
    }

    void addYNewPages(Collection<Double> yNewPages) {
        for (Tile tile : this.tiles) {
            if (tile instanceof GroupingTile) {
                ((GroupingTile)tile).addYNewPages(yNewPages);
            }
            if (!(tile instanceof NewpageTile)) continue;
            double y = ((NewpageTile)tile).getCallbackY();
            yNewPages.add(y);
        }
    }
}

