/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.stats;

import java.util.prefs.Preferences;
import znaishaded.net.sourceforge.plantuml.api.NumberAnalyzed;
import znaishaded.net.sourceforge.plantuml.api.NumberAnalyzedDated;

public class ParsedGenerated {
    private final NumberAnalyzed parsed;
    private final NumberAnalyzed generated;

    private ParsedGenerated(NumberAnalyzed parsed, NumberAnalyzed generated) {
        if (parsed == null || generated == null) {
            throw new IllegalArgumentException();
        }
        this.parsed = parsed;
        this.generated = generated;
    }

    public void reset() {
        this.parsed.reset();
        this.generated.reset();
    }

    public static ParsedGenerated createVolatile() {
        return new ParsedGenerated(new NumberAnalyzed(), new NumberAnalyzed());
    }

    public static ParsedGenerated createVolatileDated() {
        return new ParsedGenerated(new NumberAnalyzedDated(), new NumberAnalyzedDated());
    }

    public static ParsedGenerated loadDated(Preferences prefs, String name) {
        NumberAnalyzedDated generated;
        NumberAnalyzedDated parsed = NumberAnalyzedDated.load(name + ".p", prefs);
        if (parsed == null) {
            parsed = new NumberAnalyzedDated(name + ".p");
        }
        if ((generated = NumberAnalyzedDated.load(name + ".g", prefs)) == null) {
            generated = new NumberAnalyzedDated(name + ".g");
        }
        return new ParsedGenerated(parsed, generated);
    }

    public NumberAnalyzed parsed() {
        return this.parsed;
    }

    public NumberAnalyzed generated() {
        return this.generated;
    }

    public NumberAnalyzedDated parsedDated() {
        return (NumberAnalyzedDated)this.parsed;
    }

    public NumberAnalyzedDated generatedDated() {
        return (NumberAnalyzedDated)this.generated;
    }

    public long getId() {
        String comment = this.parsedDated().getComment();
        int x = comment.indexOf(47);
        if (x == -1) {
            return -1L;
        }
        return Long.parseLong(comment.substring(0, x), 36);
    }

    public String getVersion() {
        String comment = this.parsedDated().getComment();
        int x = comment.indexOf(47);
        if (x == -1) {
            return " ";
        }
        return comment.substring(x + 1);
    }
}

