/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageLollipopInterface
extends AbstractEntityImage {
    private static final int SIZE = 10;
    private final TextBlock desc;
    private final Url url;
    private double angle;

    public EntityImageLollipopInterface(ILeaf entity, ISkinParam skinParam) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        this.desc = entity.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.CLASS, stereotype), HorizontalAlignment.CENTER, skinParam);
        this.url = entity.getUrl99();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(10.0, 10.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle;
        if (this.getEntity().getLeafType() == LeafType.LOLLIPOP_HALF) {
            circle = new UEllipse(10.0, 10.0, this.angle - 90.0, 180.0);
        } else {
            circle = new UEllipse(10.0, 10.0);
            if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
                circle.setDeltaShadow(4.0);
            }
        }
        ug = ug.apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBackground).bg()).apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.classBorder));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug.apply(new UStroke(1.5)).draw(circle);
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double widthDesc = dimDesc.getWidth();
        double x = 5.0 - widthDesc / 2.0;
        double y = 10.0;
        this.desc.drawU(ug.apply(new UTranslate(x, 10.0)));
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE_IN_RECT;
    }

    public void addImpact(double angle) {
        this.angle = 180.0 - angle * 180.0 / Math.PI;
    }
}

