/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImagePseudoState
extends AbstractEntityImage {
    private static final int SIZE = 22;
    private final TextBlock desc;

    public EntityImagePseudoState(ILeaf entity, ISkinParam skinParam) {
        this(entity, skinParam, "H");
    }

    public EntityImagePseudoState(ILeaf entity, ISkinParam skinParam, String historyText) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        this.desc = Display.create(historyText).create(new FontConfiguration(this.getSkinParam(), FontParam.STATE, stereotype), HorizontalAlignment.CENTER, skinParam);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(22.0, 22.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle = new UEllipse(22.0, 22.0);
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            circle.setDeltaShadow(4.0);
        }
        ug = ug.apply(new UStroke(1.5));
        ug = ug.apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBackground).bg()).apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBorder));
        ug.draw(circle);
        ug = ug.apply(new UStroke());
        Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double widthDesc = dimDesc.getWidth();
        double heightDesc = dimDesc.getHeight();
        double x = (22.0 - widthDesc) / 2.0;
        double y = (22.0 - heightDesc) / 2.0;
        this.desc.drawU(ug.apply(new UTranslate(x, y)));
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

