/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.svg;

import znaishaded.net.sourceforge.plantuml.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverPathSvg
extends DriverShadowedG2d
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverPathSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UPath shape = (UPath)ushape;
        UClip clip = this.clipContainer.getClip();
        if (clip != null && !clip.isInside(x, y, shape)) {
            return;
        }
        String color = mapper.toSvg(param.getColor());
        if (shape.isOpenIconic()) {
            svg.setFillColor(color);
            svg.setStrokeColor("");
            svg.setStrokeWidth(0.0, "");
        } else {
            HColor back = param.getBackcolor();
            if (back instanceof HColorGradient) {
                HColorGradient gr = (HColorGradient)back;
                String id = svg.createSvgGradient(mapper.toRGB(gr.getColor1()), mapper.toRGB(gr.getColor2()), gr.getPolicy());
                svg.setFillColor("url(#" + id + ")");
            } else {
                String backcolor = mapper.toSvg(back);
                svg.setFillColor(backcolor);
            }
            svg.setStrokeColor(color);
            svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        }
        svg.svgPath(x, y, shape, shape.getDeltaShadow());
    }
}

