/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.cpp.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.cpp.parser.CPP14BaseVisitor;
import org.testingisdocumenting.znai.cpp.parser.CPP14Parser;
import org.testingisdocumenting.znai.cpp.parser.EntryDef;
import org.testingisdocumenting.znai.cpp.parser.ObjectsDefinitionTokensProcessor;
import org.testingisdocumenting.znai.utils.StringUtils;
import znaishaded.org.antlr.v4.runtime.Token;

public class ExtractBodyVisitor
extends CPP14BaseVisitor {
    private final List<String> lines;
    private CPP14Parser parser;
    private String code;
    private List<EntryDef> entries;

    public ExtractBodyVisitor(CPP14Parser parser, String code) {
        this.parser = parser;
        this.code = code;
        this.lines = Arrays.asList(code.replace("\r", "").split("\n"));
        this.entries = new ArrayList<EntryDef>();
    }

    public Stream<EntryDef> getEntries() {
        return this.entries.stream();
    }

    @Override
    public Object visitTranslationunit(CPP14Parser.TranslationunitContext ctx) {
        Object translationunit = super.visitTranslationunit(ctx);
        ObjectsDefinitionTokensProcessor objectsDefinitionTokensProcessor = new ObjectsDefinitionTokensProcessor(this.lines);
        this.entries.addAll(objectsDefinitionTokensProcessor.process(this.parser));
        return translationunit;
    }

    @Override
    public Object visitFunctiondefinition(CPP14Parser.FunctiondefinitionContext ctx) {
        String methodName = this.textBeforeParenthesis(ctx.declarator().getText());
        EntryDef method = new EntryDef(methodName, this.codeContent(ctx.getStart(), ctx.getStop()), StringUtils.stripIndentation(this.removeBrackets(ctx.functionbody().getStart(), ctx.functionbody().getStop())));
        this.entries.add(method);
        return super.visitFunctiondefinition(ctx);
    }

    private String textBeforeParenthesis(String text) {
        int idx = text.indexOf(40);
        return idx == -1 ? text : text.substring(0, idx);
    }

    private String removeBrackets(Token start, Token stop) {
        return this.code.substring(start.getStartIndex() + 1, stop.getStartIndex());
    }

    private String codeContent(Token start, Token stop) {
        return this.code.substring(start.getStartIndex(), stop.getStartIndex() + 1);
    }
}

