/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.javaparser.printer;

import java.util.function.Function;
import znaishaded.com.github.javaparser.ast.visitor.VoidVisitor;
import znaishaded.com.github.javaparser.printer.PrettyPrintVisitor;
import znaishaded.com.github.javaparser.utils.Utils;

public class PrettyPrinterConfiguration {
    public static final int DEFAULT_MAX_ENUM_CONSTANTS_TO_ALIGN_HORIZONTALLY = 5;
    private boolean orderImports = false;
    private boolean printComments = true;
    private boolean printJavadoc = true;
    private boolean spaceAroundOperators = true;
    private boolean columnAlignParameters = false;
    private boolean columnAlignFirstMethodChain = false;
    private boolean indentCaseInSwitch = true;
    private IndentType indentType = IndentType.SPACES;
    private int tabWidth = 4;
    private int indentSize = 4;
    private String endOfLineCharacter = Utils.EOL;
    private Function<PrettyPrinterConfiguration, VoidVisitor<Void>> visitorFactory = PrettyPrintVisitor::new;
    private int maxEnumConstantsToAlignHorizontally = 5;

    public String getIndent() {
        char indentChar;
        StringBuilder indentString = new StringBuilder();
        switch (this.indentType) {
            case SPACES: {
                indentChar = ' ';
                break;
            }
            case TABS: 
            case TABS_WITH_SPACE_ALIGN: {
                indentChar = '\t';
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled indent type");
            }
        }
        for (int i = 0; i < this.indentSize; ++i) {
            indentString.append(indentChar);
        }
        return indentString.toString();
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public PrettyPrinterConfiguration setIndentSize(int indentSize) {
        this.indentSize = Utils.assertNonNegative(indentSize);
        return this;
    }

    public IndentType getIndentType() {
        return this.indentType;
    }

    public PrettyPrinterConfiguration setIndentType(IndentType indentType) {
        this.indentType = Utils.assertNotNull(indentType);
        return this;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public PrettyPrinterConfiguration setTabWidth(int tabWidth) {
        this.tabWidth = Utils.assertPositive(tabWidth);
        return this;
    }

    public boolean isOrderImports() {
        return this.orderImports;
    }

    public boolean isPrintComments() {
        return this.printComments;
    }

    public boolean isIgnoreComments() {
        return !this.printComments;
    }

    public boolean isSpaceAroundOperators() {
        return this.spaceAroundOperators;
    }

    public boolean isPrintJavadoc() {
        return this.printJavadoc;
    }

    public boolean isColumnAlignParameters() {
        return this.columnAlignParameters;
    }

    public boolean isColumnAlignFirstMethodChain() {
        return this.columnAlignFirstMethodChain;
    }

    public boolean isIndentCaseInSwitch() {
        return this.indentCaseInSwitch;
    }

    public PrettyPrinterConfiguration setPrintComments(boolean printComments) {
        this.printComments = printComments;
        return this;
    }

    public PrettyPrinterConfiguration setPrintJavadoc(boolean printJavadoc) {
        this.printJavadoc = printJavadoc;
        return this;
    }

    public PrettyPrinterConfiguration setSpaceAroundOperators(boolean spaceAroundOperators) {
        this.spaceAroundOperators = spaceAroundOperators;
        return this;
    }

    public PrettyPrinterConfiguration setColumnAlignParameters(boolean columnAlignParameters) {
        this.columnAlignParameters = columnAlignParameters;
        return this;
    }

    public PrettyPrinterConfiguration setColumnAlignFirstMethodChain(boolean columnAlignFirstMethodChain) {
        this.columnAlignFirstMethodChain = columnAlignFirstMethodChain;
        return this;
    }

    public PrettyPrinterConfiguration setIndentCaseInSwitch(boolean indentInSwitch) {
        this.indentCaseInSwitch = indentInSwitch;
        return this;
    }

    public Function<PrettyPrinterConfiguration, VoidVisitor<Void>> getVisitorFactory() {
        return this.visitorFactory;
    }

    public PrettyPrinterConfiguration setVisitorFactory(Function<PrettyPrinterConfiguration, VoidVisitor<Void>> visitorFactory) {
        this.visitorFactory = Utils.assertNotNull(visitorFactory);
        return this;
    }

    public String getEndOfLineCharacter() {
        return this.endOfLineCharacter;
    }

    public PrettyPrinterConfiguration setEndOfLineCharacter(String endOfLineCharacter) {
        this.endOfLineCharacter = Utils.assertNotNull(endOfLineCharacter);
        return this;
    }

    public PrettyPrinterConfiguration setOrderImports(boolean orderImports) {
        this.orderImports = orderImports;
        return this;
    }

    public int getMaxEnumConstantsToAlignHorizontally() {
        return this.maxEnumConstantsToAlignHorizontally;
    }

    public PrettyPrinterConfiguration setMaxEnumConstantsToAlignHorizontally(int maxEnumConstantsToAlignHorizontally) {
        this.maxEnumConstantsToAlignHorizontally = maxEnumConstantsToAlignHorizontally;
        return this;
    }

    public static enum IndentType {
        SPACES,
        TABS,
        TABS_WITH_SPACE_ALIGN;

    }
}

