/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLHandshakeException;
import znaishaded.io.netty.bootstrap.Bootstrap;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelFuture;
import znaishaded.io.netty.channel.ChannelHandler;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.channel.ChannelInboundHandlerAdapter;
import znaishaded.io.netty.channel.ChannelInitializer;
import znaishaded.io.netty.channel.ChannelPipeline;
import znaishaded.io.netty.handler.proxy.HttpProxyHandler;
import znaishaded.io.netty.handler.proxy.ProxyConnectionEvent;
import znaishaded.io.netty.handler.proxy.ProxyHandler;
import znaishaded.io.netty.handler.proxy.Socks4ProxyHandler;
import znaishaded.io.netty.handler.proxy.Socks5ProxyHandler;
import znaishaded.io.netty.handler.ssl.SslHandler;
import znaishaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import znaishaded.io.netty.resolver.NoopAddressResolverGroup;
import znaishaded.io.netty.util.concurrent.GenericFutureListener;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Context;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.impl.ContextInternal;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.net.ProxyOptions;
import znaishaded.io.vertx.core.net.ProxyType;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.net.impl.SSLHelper;

public final class ChannelProvider {
    private final Bootstrap bootstrap;
    private final SSLHelper sslHelper;
    private final ContextInternal context;
    private final ProxyOptions proxyOptions;
    private String applicationProtocol;
    private Channel channel;

    public ChannelProvider(Bootstrap bootstrap, SSLHelper sslHelper, ContextInternal context, ProxyOptions proxyOptions) {
        this.bootstrap = bootstrap;
        this.context = context;
        this.sslHelper = sslHelper;
        this.proxyOptions = proxyOptions;
    }

    public String applicationProtocol() {
        return this.applicationProtocol;
    }

    public Channel channel() {
        return this.channel;
    }

    public void connect(SocketAddress remoteAddress, SocketAddress peerAddress, String serverName, boolean ssl, Handler<AsyncResult<Channel>> channelHandler) {
        Handler<AsyncResult<Channel>> handler = res -> {
            if (Context.isOnEventLoopThread()) {
                channelHandler.handle((AsyncResult<Channel>)res);
            } else {
                this.context.nettyEventLoop().execute(() -> channelHandler.handle((AsyncResult<Channel>)res));
            }
        };
        try {
            this.bootstrap.channelFactory(this.context.owner().transport().channelFactory(remoteAddress.path() != null));
        }
        catch (Exception e) {
            channelHandler.handle(Future.failedFuture(e));
            return;
        }
        if (this.proxyOptions != null) {
            this.handleProxyConnect(remoteAddress, peerAddress, serverName, ssl, handler);
        } else {
            this.handleConnect(remoteAddress, peerAddress, serverName, ssl, handler);
        }
    }

    private void initSSL(SocketAddress peerAddress, String serverName, boolean ssl, Channel ch, final Handler<AsyncResult<Channel>> channelHandler) {
        if (ssl) {
            final SslHandler sslHandler = new SslHandler(this.sslHelper.createEngine(this.context.owner(), peerAddress, serverName));
            sslHandler.setHandshakeTimeout(this.sslHelper.getSslHandshakeTimeout(), this.sslHelper.getSslHandshakeTimeoutUnit());
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
            pipeline.addLast(new ChannelInboundHandlerAdapter(){

                @Override
                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                    if (evt instanceof SslHandshakeCompletionEvent) {
                        SslHandshakeCompletionEvent completion = (SslHandshakeCompletionEvent)evt;
                        if (completion.isSuccess()) {
                            ctx.pipeline().remove(this);
                            ChannelProvider.this.applicationProtocol = sslHandler.applicationProtocol();
                            channelHandler.handle(Future.succeededFuture(ChannelProvider.this.channel));
                        } else {
                            SSLHandshakeException sslException = new SSLHandshakeException("Failed to create SSL connection");
                            sslException.initCause(completion.cause());
                            channelHandler.handle(Future.failedFuture(sslException));
                        }
                    }
                    ctx.fireUserEventTriggered(evt);
                }

                @Override
                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                }
            });
        }
    }

    private void handleConnect(SocketAddress remoteAddress, final SocketAddress peerAddress, final String serverName, final boolean ssl, final Handler<AsyncResult<Channel>> channelHandler) {
        VertxInternal vertx = this.context.owner();
        this.bootstrap.resolver(vertx.nettyAddressResolverGroup());
        this.bootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) {
                ChannelProvider.this.initSSL(peerAddress, serverName, ssl, ch, channelHandler);
            }
        });
        ChannelFuture fut = this.bootstrap.connect(vertx.transport().convert(remoteAddress, false));
        fut.addListener((GenericFutureListener<? extends znaishaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<znaishaded.io.netty.util.concurrent.Future>)res -> {
            if (res.isSuccess()) {
                this.connected(fut.channel(), ssl, channelHandler);
            } else {
                channelHandler.handle(Future.failedFuture(res.cause()));
            }
        }));
    }

    private void connected(Channel channel, boolean ssl, Handler<AsyncResult<Channel>> channelHandler) {
        this.channel = channel;
        if (!ssl) {
            channelHandler.handle(Future.succeededFuture(this.channel));
        }
    }

    private void handleProxyConnect(SocketAddress remoteAddress, final SocketAddress peerAddress, final String serverName, final boolean ssl, final Handler<AsyncResult<Channel>> channelHandler) {
        VertxInternal vertx = this.context.owner();
        String proxyHost = this.proxyOptions.getHost();
        int proxyPort = this.proxyOptions.getPort();
        String proxyUsername = this.proxyOptions.getUsername();
        String proxyPassword = this.proxyOptions.getPassword();
        ProxyType proxyType = this.proxyOptions.getType();
        vertx.resolveAddress(proxyHost, dnsRes -> {
            if (dnsRes.succeeded()) {
                ProxyHandler proxy;
                InetAddress address = (InetAddress)dnsRes.result();
                InetSocketAddress proxyAddr = new InetSocketAddress(address, proxyPort);
                switch (proxyType) {
                    default: {
                        proxy = proxyUsername != null && proxyPassword != null ? new HttpProxyHandler((java.net.SocketAddress)proxyAddr, proxyUsername, proxyPassword) : new HttpProxyHandler(proxyAddr);
                        break;
                    }
                    case SOCKS5: {
                        proxy = proxyUsername != null && proxyPassword != null ? new Socks5ProxyHandler(proxyAddr, proxyUsername, proxyPassword) : new Socks5ProxyHandler(proxyAddr);
                        break;
                    }
                    case SOCKS4: {
                        proxy = proxyUsername != null ? new Socks4ProxyHandler(proxyAddr, proxyUsername) : new Socks4ProxyHandler(proxyAddr);
                    }
                }
                this.bootstrap.resolver(NoopAddressResolverGroup.INSTANCE);
                java.net.SocketAddress targetAddress = vertx.transport().convert(remoteAddress, false);
                this.bootstrap.handler(new ChannelInitializer<Channel>(){

                    @Override
                    protected void initChannel(final Channel ch) throws Exception {
                        final ChannelPipeline pipeline = ch.pipeline();
                        pipeline.addFirst("proxy", (ChannelHandler)proxy);
                        pipeline.addLast(new ChannelInboundHandlerAdapter(){

                            @Override
                            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                                if (evt instanceof ProxyConnectionEvent) {
                                    pipeline.remove(proxy);
                                    pipeline.remove(this);
                                    ChannelProvider.this.initSSL(peerAddress, serverName, ssl, ch, channelHandler);
                                    ChannelProvider.this.connected(ch, ssl, channelHandler);
                                }
                                ctx.fireUserEventTriggered(evt);
                            }

                            @Override
                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                                channelHandler.handle(Future.failedFuture(cause));
                            }
                        });
                    }
                });
                ChannelFuture future = this.bootstrap.connect(targetAddress);
                future.addListener((GenericFutureListener<? extends znaishaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<znaishaded.io.netty.util.concurrent.Future>)res -> {
                    if (!res.isSuccess()) {
                        channelHandler.handle(Future.failedFuture(res.cause()));
                    }
                }));
            } else {
                channelHandler.handle(Future.failedFuture(dnsRes.cause()));
            }
        });
    }
}

