/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.braille;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.TikzFontDistortion;
import znaishaded.net.sourceforge.plantuml.braille.BrailleDrawer;
import znaishaded.net.sourceforge.plantuml.braille.BrailleGrid;
import znaishaded.net.sourceforge.plantuml.braille.DriverCenteredCharacterBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverDotPathBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverLineBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverNoneBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverPolygonBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverRectangleBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverTextBraille;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.posimo.DotPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic2;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class UGraphicBraille
extends AbstractUGraphic<BrailleGrid>
implements ClipContainer,
UGraphic2 {
    public static final int QUANTA = 4;
    private final BrailleGrid grid;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicBraille(this);
    }

    public UGraphicBraille(ColorMapper colorMapper, FileFormat fileFormat) {
        this(colorMapper, new BrailleGrid(4.0));
    }

    private UGraphicBraille(UGraphicBraille other) {
        super(other);
        this.grid = other.grid;
        this.register();
    }

    private UGraphicBraille(ColorMapper colorMapper, BrailleGrid grid) {
        super(colorMapper, grid);
        this.grid = grid;
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverNoneBraille());
        this.registerDriver(URectangle.class, new DriverRectangleBraille(this));
        this.registerDriver(UText.class, new DriverTextBraille());
        this.registerDriver(ULine.class, new DriverLineBraille(this));
        this.registerDriver(UPolygon.class, new DriverPolygonBraille(this));
        this.registerDriver(UEllipse.class, new DriverNoneBraille());
        this.registerDriver(UImage.class, new DriverNoneBraille());
        this.registerDriver(UPath.class, new DriverNoneBraille());
        this.registerDriver(DotPath.class, new DriverDotPathBraille());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterBraille());
    }

    @Override
    public StringBounder getStringBounder() {
        return FileFormat.BRAILLE_PNG.getDefaultStringBounder(TikzFontDistortion.getDefault());
    }

    @Override
    public void writeImageTOBEMOVED(OutputStream os, String metadata, int dpi) throws IOException {
        ImageBuilder imageBuilder = ImageBuilder.buildA(new ColorMapperIdentity(), false, null, metadata, null, 1.0, HColorUtils.WHITE);
        imageBuilder.setUDrawable(new BrailleDrawer((BrailleGrid)this.getGraphicObject()));
        imageBuilder.writeImageTOBEMOVED(new FileFormatOption(FileFormat.PNG), 42L, os);
    }
}

