/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.ScaleSimple;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;

public class CommandScale
extends SingleLineCommand2<AbstractPSystem> {
    public CommandScale() {
        super(CommandScale.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandScale.class.getName(), RegexLeaf.start(), new RegexLeaf("scale"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("SCALE", "([0-9.]+)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("/"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DIV", "([0-9.]+)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractPSystem diagram, LineLocation location, RegexResult arg) {
        double scale = Double.parseDouble(arg.get("SCALE", 0));
        if (scale == 0.0) {
            return CommandExecutionResult.error("Scale cannot be zero");
        }
        if (arg.get("DIV", 0) != null) {
            double div = Double.parseDouble(arg.get("DIV", 0));
            if (div == 0.0) {
                return CommandExecutionResult.error("Scale cannot be zero");
            }
            scale /= div;
        }
        diagram.setScale(new ScaleSimple(scale));
        return CommandExecutionResult.ok();
    }
}

