/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.awt.geom.Point2D;
import java.util.Locale;
import znaishaded.net.sourceforge.plantuml.geom.AbstractLineSegment;
import znaishaded.net.sourceforge.plantuml.geom.Box;
import znaishaded.net.sourceforge.plantuml.geom.InflateData;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;

public class LineSegmentInt
extends AbstractLineSegment {
    private final Point2DInt p1;
    private final Point2DInt p2;

    public String toString() {
        return String.format(Locale.US, "( %d,%d - %d,%d )", this.p1.getXint(), this.p1.getYint(), this.p2.getXint(), this.p2.getYint());
    }

    public LineSegmentInt(int x1, int y1, int x2, int y2) {
        this(new Point2DInt(x1, y1), new Point2DInt(x2, y2));
    }

    public LineSegmentInt(Point2DInt p1, Point2DInt p2) {
        this.p1 = p1;
        this.p2 = p2;
        if (p1.equals(p2)) {
            throw new IllegalArgumentException();
        }
        assert (p1 != null && p2 != null);
        assert (this.getLength() > 0.0);
        assert (this.getDistance(this) == 0.0);
    }

    public boolean containsPoint(Point2D point) {
        return this.side(point) == 0.0 && LineSegmentInt.isBetween(point, this.p1, this.p2);
    }

    public double side(Box box) {
        Point2DInt[] corners = box.getCorners();
        double s0 = this.side(corners[0]);
        double s1 = this.side(corners[1]);
        double s2 = this.side(corners[2]);
        double s3 = this.side(corners[3]);
        if (s0 > 0.0 && s1 > 0.0 && s2 > 0.0 && s3 > 0.0) {
            return 1.0;
        }
        if (s0 < 0.0 && s1 < 0.0 && s2 < 0.0 && s3 < 0.0) {
            return -1.0;
        }
        return 0.0;
    }

    public boolean doesIntersectButNotSameExtremity(LineSegmentInt other) {
        if (!this.doesIntersect(other)) {
            return false;
        }
        return !this.atLeastOneCommonExtremities(other);
    }

    public boolean sameExtremities(LineSegmentInt other) {
        if (this.p1.equals(other.p1) && this.p2.equals(other.p2)) {
            return true;
        }
        return this.p1.equals(other.p2) && this.p2.equals(other.p1);
    }

    public boolean atLeastOneCommonExtremities(LineSegmentInt other) {
        if (this.p1.equals(other.p1)) {
            return true;
        }
        if (this.p1.equals(other.p2)) {
            return true;
        }
        if (this.p2.equals(other.p1)) {
            return true;
        }
        return this.p2.equals(other.p2);
    }

    public Point2DInt getCommonExtremities(LineSegmentInt other) {
        if (this.p1.equals(other.p1)) {
            return this.p1;
        }
        if (this.p1.equals(other.p2)) {
            return this.p1;
        }
        if (this.p2.equals(other.p1)) {
            return this.p2;
        }
        if (this.p2.equals(other.p2)) {
            return this.p2;
        }
        return null;
    }

    public Point2DInt getOtherExtremity(Point2DInt extremity1) {
        if (extremity1 == null) {
            throw new IllegalArgumentException();
        }
        if (extremity1.equals(this.p1)) {
            return this.p2;
        }
        if (extremity1.equals(this.p2)) {
            return this.p1;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Point2DInt getP1() {
        return this.p1;
    }

    @Override
    public Point2DInt getP2() {
        return this.p2;
    }

    @Override
    public double getX1() {
        return this.p1.getXint();
    }

    @Override
    public double getX2() {
        return this.p2.getXint();
    }

    @Override
    public double getY1() {
        return this.p1.getYint();
    }

    @Override
    public double getY2() {
        return this.p2.getYint();
    }

    public Point2DInt getTranslatedPoint(Point2DInt pointToBeTranslated) {
        int x = this.p2.getXint() - this.p1.getXint();
        int y = this.p2.getYint() - this.p1.getYint();
        return new Point2DInt(pointToBeTranslated.getXint() + x, pointToBeTranslated.getYint() + y);
    }

    public Point2DInt getCenter() {
        return new Point2DInt((this.p1.getXint() + this.p2.getXint()) / 2, (this.p1.getYint() + this.p2.getYint()) / 2);
    }

    public int getMinX() {
        return Math.min(this.p1.getXint(), this.p2.getXint());
    }

    public int getMaxX() {
        return Math.max(this.p1.getXint(), this.p2.getXint());
    }

    public int getMinY() {
        return Math.min(this.p1.getYint(), this.p2.getYint());
    }

    public int getMaxY() {
        return Math.max(this.p1.getYint(), this.p2.getYint());
    }

    public Point2DInt ortho(Point2D.Double orig, double d) {
        double vectX = this.p2.getY() - this.p1.getY();
        double vectY = -(this.p2.getX() - this.p1.getX());
        double pour = 1.0 * d / 100.0;
        double x = orig.x + vectX * pour;
        double y = orig.y + vectY * pour;
        return new Point2DInt((int)Math.round(x), (int)Math.round(y));
    }

    public LineSegmentInt translate(int deltaX, int deltaY) {
        return new LineSegmentInt(this.p1.translate(deltaX, deltaY), this.p2.translate(deltaX, deltaY));
    }

    public LineSegmentInt inflateXAlpha(InflateData inflateData) {
        int xpos = inflateData.getPos();
        int inflation = inflateData.getInflation();
        if (this.isHorizontal()) {
            return new LineSegmentInt(this.p1.inflateX(inflateData), this.p2.inflateX(inflateData));
        }
        if (this.getP1().getXint() == xpos && this.getP2().getXint() == xpos) {
            return this.translate(inflation / 2, 0);
        }
        if (this.getP1().getXint() <= xpos && this.getP2().getXint() <= xpos) {
            return this;
        }
        if (this.getP1().getXint() >= xpos && this.getP2().getXint() >= xpos) {
            return this.translate(inflation, 0);
        }
        throw new UnsupportedOperationException(this.toString() + " " + inflateData);
    }

    public LineSegmentInt inflateYAlpha(InflateData inflateData) {
        int ypos = inflateData.getPos();
        int inflation = inflateData.getInflation();
        if (this.isVertical()) {
            return new LineSegmentInt(this.p1.inflateY(inflateData), this.p2.inflateY(inflateData));
        }
        if (this.getP1().getYint() == ypos && this.getP2().getYint() == ypos) {
            return this.translate(0, inflation / 2);
        }
        if (this.getP1().getYint() <= ypos && this.getP2().getYint() <= ypos) {
            return this;
        }
        if (this.getP1().getYint() >= ypos && this.getP2().getYint() >= ypos) {
            return this.translate(0, inflation);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Point2DInt getSegIntersection(AbstractLineSegment other) {
        Point2D result = super.getSegIntersection(other);
        if (result == null) {
            return null;
        }
        return new Point2DInt((int)Math.round(result.getX()), (int)Math.round(result.getY()));
    }
}

