/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.skin.VisibilityModifier;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class MethodsOrFieldsArea {
    private final UFont font;
    private final List<String> strings = new ArrayList<String>();

    public MethodsOrFieldsArea(List<Member> attributes, UFont font) {
        this.font = font;
        for (Member att : attributes) {
            this.strings.add(att.getDisplay(false));
        }
    }

    public VisibilityModifier getVisibilityModifier() {
        throw new UnsupportedOperationException();
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double x = 0.0;
        double y = 0.0;
        for (String s2 : this.strings) {
            TextBlock bloc = this.createTextBlock(s2);
            Dimension2D dim = bloc.calculateDimension(stringBounder);
            y += dim.getHeight();
            x = Math.max(dim.getWidth(), x);
        }
        return new Dimension2DDouble(x, y);
    }

    private TextBlock createTextBlock(String s2) {
        return Display.create(s2).create(FontConfiguration.blackBlueTrue(this.font), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    public void draw(UGraphic ug, double x, double y) {
        for (String s2 : this.strings) {
            TextBlock bloc = this.createTextBlock(s2);
            bloc.drawU(ug.apply(new UTranslate(x, y)));
            y += bloc.calculateDimension(ug.getStringBounder()).getHeight();
        }
    }
}

