/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.graph.SortedCollection;

public class SortedCollectionArrayList<S extends Comparable<S>>
implements SortedCollection<S> {
    private final List<S> allAsList = new ArrayList<S>();
    private final Set<S> allAsSet = new HashSet<S>();

    @Override
    public Iterator<S> iterator() {
        return this.allAsList.iterator();
    }

    @Override
    public void add(S newEntry) {
        int r = Collections.binarySearch(this.allAsList, newEntry);
        if (r >= 0) {
            this.allAsList.add(r, newEntry);
        } else {
            this.allAsList.add(-1 - r, newEntry);
        }
        this.allAsSet.add(newEntry);
        assert (this.isSorted());
    }

    @Override
    public int size() {
        assert (this.allAsSet.size() == this.allAsList.size());
        return this.allAsList.size();
    }

    List<S> toList() {
        return new ArrayList<S>(this.allAsList);
    }

    boolean isSorted() {
        Comparable before = null;
        for (Comparable ent : this.allAsList) {
            if (before != null && ent.compareTo(before) < 0) {
                return false;
            }
            before = ent;
        }
        return true;
    }

    @Override
    public boolean contains(S entry) {
        return this.allAsSet.contains(entry);
    }
}

