/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.hector.Pin;
import znaishaded.net.sourceforge.plantuml.hector.PinLink;
import znaishaded.net.sourceforge.plantuml.hector.Skeleton;

public class GrowingTree {
    private final List<PinLink> all = new ArrayList<PinLink>();
    private final Map<Pin, ArrayList<Pin>> directlyAfter = new HashMap<Pin, ArrayList<Pin>>();

    public Skeleton createSkeleton() {
        LinkedHashSet<Pin> pins = new LinkedHashSet<Pin>();
        for (PinLink link : this.all) {
            pins.add(link.getPin1());
            pins.add(link.getPin2());
        }
        this.normalizeRowToZero(pins);
        return new Skeleton(new ArrayList<Pin>(pins), new ArrayList<PinLink>(this.all));
    }

    private void normalizeRowToZero(Collection<Pin> pins) {
        int minRow = Integer.MAX_VALUE;
        for (Pin p : pins) {
            int r = p.getRow();
            if (r == Integer.MAX_VALUE) {
                throw new IllegalStateException();
            }
            if (r >= minRow) continue;
            minRow = r;
        }
        for (Pin p : pins) {
            p.push(-minRow);
        }
    }

    public boolean canBeAdded(PinLink candidat) {
        if (this.all.size() == 0) {
            return true;
        }
        Pin p1 = candidat.getPin1();
        Pin p2 = candidat.getPin2();
        return p1.getRow() != Integer.MAX_VALUE || p2.getRow() != Integer.MAX_VALUE;
    }

    public void add(PinLink newPinLink) {
        Pin p1 = newPinLink.getPin1();
        Pin p2 = newPinLink.getPin2();
        if (this.all.size() == 0) {
            newPinLink.getPin1().setRow(0);
            this.simpleRowComputation(newPinLink);
        } else if (this.isPartiallyNew(newPinLink)) {
            this.simpleRowComputation(newPinLink);
        } else if (p1.getRow() != Integer.MAX_VALUE && p2.getRow() != Integer.MAX_VALUE) {
            int actualRowDiff = p2.getRow() - p1.getRow();
            int neededPushForP2 = newPinLink.getLengthStandard() - actualRowDiff;
            this.push(p2, neededPushForP2);
        } else {
            throw new IllegalArgumentException();
        }
        this.all.add(newPinLink);
        this.getDirectlyAfter(p1).add(p2);
    }

    private List<Pin> getDirectlyAfter(Pin p) {
        ArrayList<Pin> result = this.directlyAfter.get(p);
        if (result == null) {
            result = new ArrayList();
            this.directlyAfter.put(p, result);
        }
        return result;
    }

    private Collection<Pin> getIndirectlyAfter(Pin pin) {
        HashSet<Pin> result = new HashSet<Pin>(this.getDirectlyAfter(pin));
        int lastSize = result.size();
        while (true) {
            for (Pin p : new ArrayList<Pin>(result)) {
                result.addAll(this.getDirectlyAfter(p));
            }
            if (result.size() == lastSize) {
                return result;
            }
            lastSize = result.size();
        }
    }

    private void push(Pin p, int push) {
        if (push <= 0) {
            return;
        }
        Collection<Pin> after = this.getIndirectlyAfter(p);
        if (after.contains(p)) {
            throw new IllegalStateException();
        }
        p.push(push);
        for (Pin pp : after) {
            pp.push(push);
        }
    }

    private void simpleRowComputation(PinLink link) {
        Pin p1 = link.getPin1();
        Pin p2 = link.getPin2();
        if (p1.getRow() == Integer.MAX_VALUE && p2.getRow() != Integer.MAX_VALUE) {
            p1.setRow(p2.getRow() - link.getLengthStandard());
        } else if (p1.getRow() != Integer.MAX_VALUE && p2.getRow() == Integer.MAX_VALUE) {
            p2.setRow(p1.getRow() + link.getLengthStandard());
        } else {
            throw new IllegalArgumentException();
        }
    }

    private boolean isPartiallyNew(PinLink link) {
        Pin p1 = link.getPin1();
        Pin p2 = link.getPin2();
        if (p1.getRow() == Integer.MAX_VALUE && p2.getRow() != Integer.MAX_VALUE) {
            return true;
        }
        return p1.getRow() != Integer.MAX_VALUE && p2.getRow() == Integer.MAX_VALUE;
    }

    public void normalizeRowToZero() {
    }
}

