/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

abstract class AbstractElementText
extends AbstractElement {
    private final TextBlock block;
    private final FontConfiguration config;
    private final int charLength;

    public AbstractElementText(String text, UFont font, boolean manageLength, ISkinSimple spriteContainer) {
        this.config = FontConfiguration.blackBlueTrue(font);
        if (manageLength) {
            this.charLength = this.getCharNumber(text);
            text = StringUtils.trin(text);
        } else {
            this.charLength = 0;
        }
        this.block = Display.create(text).create(this.config, HorizontalAlignment.LEFT, spriteContainer);
    }

    private int getCharNumber(String text) {
        text = text.replaceAll("<&[-\\w]+>", "00");
        return text.length();
    }

    protected void drawText(UGraphic ug, double x, double y) {
        this.block.drawU(ug.apply(new UTranslate(x, y)));
    }

    protected Dimension2D getPureTextDimension(StringBounder stringBounder) {
        return this.block.calculateDimension(stringBounder);
    }

    protected Dimension2D getTextDimensionAt(StringBounder stringBounder, double x) {
        Dimension2D result = this.block.calculateDimension(stringBounder);
        if (this.charLength == 0) {
            return result;
        }
        double dimSpace = this.getSingleSpace(stringBounder);
        return new Dimension2DDouble(Math.max(result.getWidth(), (double)this.charLength * dimSpace), result.getHeight());
    }

    private double getSingleSpace(StringBounder stringBounder) {
        return 8.0;
    }

    protected final FontConfiguration getConfig() {
        return this.config;
    }
}

