/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import znaishaded.net.sourceforge.plantuml.ugraphic.USegmentType;

public class USegment {
    private final double[] coord;
    private final USegmentType pathType;

    public USegment(double[] coord, USegmentType pathType) {
        this.coord = (double[])coord.clone();
        this.pathType = pathType;
    }

    public String toString() {
        return this.pathType.toString() + " " + Arrays.toString(this.coord);
    }

    public final double[] getCoord() {
        return this.coord;
    }

    public final USegmentType getSegmentType() {
        return this.pathType;
    }

    public USegment translate(double dx, double dy) {
        if (this.coord.length != 2) {
            throw new UnsupportedOperationException();
        }
        Point2D.Double p1 = new Point2D.Double(this.coord[0] + dx, this.coord[1] + dy);
        return new USegment(new double[]{((Point2D)p1).getX(), ((Point2D)p1).getY()}, this.pathType);
    }

    public USegment rotate(double theta) {
        if (this.coord.length != 2) {
            throw new UnsupportedOperationException();
        }
        Point2D.Double p1 = new Point2D.Double(this.coord[0], this.coord[1]);
        AffineTransform rotate = AffineTransform.getRotateInstance(theta);
        rotate.transform(p1, p1);
        return new USegment(new double[]{((Point2D)p1).getX(), ((Point2D)p1).getY()}, this.pathType);
    }
}

