/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.diagrams.graphviz;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.diagrams.DiagramsGlobalAssetsRegistration;
import org.testingisdocumenting.znai.diagrams.graphviz.Graphviz;
import org.testingisdocumenting.znai.diagrams.graphviz.GraphvizDiagram;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;

public class GvDiagramIncludePlugin
implements IncludePlugin {
    @Override
    public String id() {
        return "gv-diagram";
    }

    @Override
    public IncludePlugin create() {
        return new GvDiagramIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        String diagramId = pluginParams.getFreeParam();
        String diagramPath = pluginParams.getOpts().getRequiredString("diagramPath");
        String gvContent = componentsRegistry.resourceResolver().textContent(diagramPath);
        DiagramsGlobalAssetsRegistration.register(componentsRegistry.globalAssetsRegistry());
        GraphvizDiagram diagram = Graphviz.graphvizEngine.diagramFromGv(pluginParams.getOpts().get("type", "dot"), diagramId, gvContent);
        LinkedHashMap<String, Map<String, Object>> props = new LinkedHashMap<String, Map<String, Object>>();
        props.put("diagram", diagram.toMap());
        return PluginResult.docElement("GraphVizDiagram", props);
    }
}

