/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.api;

import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.api.ApiParametersAnchors;
import org.testingisdocumenting.znai.extensions.api.ApiParametersJsonParser;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class ApiParametersIncludePlugin
implements IncludePlugin {
    private Path fullPath;
    private ApiParameters apiParameters;

    @Override
    public String id() {
        return "api-parameters";
    }

    @Override
    public IncludePlugin create() {
        return new ApiParametersIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        this.fullPath = resourcesResolver.fullPath(pluginParams.getFreeParam());
        this.apiParameters = ApiParametersJsonParser.parse(pluginParams.getOpts().get("anchorPrefix", ""), componentsRegistry.markdownParser(), resourcesResolver.textContent(this.fullPath));
        ApiParametersAnchors.registerLocalAnchors(componentsRegistry, markupPath, this.apiParameters);
        Map<String, Object> props = this.apiParameters.toMap();
        props.putAll(pluginParams.getOpts().toMap());
        return PluginResult.docElement("ApiParameters", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(this.fullPath));
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.apiParameters.combinedTextForSearch());
    }
}

