/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.extensions.features.PluginFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetContentProvider;

public class SnippetAutoTitleFeature
implements PluginFeature {
    private static final String TITLE_KEY = "title";
    private static final String AUTO_TITLE_KEY = "autoTitle";
    private final SnippetContentProvider snippetContentProvider;

    public SnippetAutoTitleFeature(SnippetContentProvider snippetContentProvider) {
        this.snippetContentProvider = snippetContentProvider;
    }

    @Override
    public void updateProps(Map<String, Object> props) {
        if (props.containsKey(TITLE_KEY) && props.containsKey(AUTO_TITLE_KEY)) {
            throw new IllegalArgumentException("Can't have both <title> and <autoTitle> specified");
        }
        Object autoTitle = props.get(AUTO_TITLE_KEY);
        if (autoTitle == null) {
            return;
        }
        if (Boolean.TRUE.equals(autoTitle)) {
            props.put(TITLE_KEY, this.snippetContentProvider.snippetId());
        }
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles() {
        return Stream.empty();
    }
}

