/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.website.markups;

import java.nio.file.Path;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParsingConfiguration;
import org.testingisdocumenting.znai.parser.sphinx.DocTreeTocGenerator;
import org.testingisdocumenting.znai.parser.sphinx.SphinxDocTreeParser;
import org.testingisdocumenting.znai.structure.TableOfContents;
import org.testingisdocumenting.znai.structure.TocItem;
import org.testingisdocumenting.znai.utils.FilePathUtils;

public class SphinxParsingConfiguration
implements MarkupParsingConfiguration {
    @Override
    public String configurationName() {
        return "sphinx";
    }

    @Override
    public TableOfContents createToc(String docTitle, ComponentsRegistry componentsRegistry) {
        return new DocTreeTocGenerator().generate(componentsRegistry.resourceResolver().textContent("index.xml"));
    }

    @Override
    public MarkupParser createMarkupParser(ComponentsRegistry componentsRegistry) {
        return new SphinxDocTreeParser(componentsRegistry);
    }

    @Override
    public String tocItemResourceName(TocItem tocItem) {
        return tocItem.getFileNameWithoutExtension() + "." + this.filesExtension();
    }

    @Override
    public Path fullPath(ComponentsRegistry componentsRegistry, Path root, TocItem tocItem) {
        return root.resolve(tocItem.getDirName()).resolve(this.tocItemResourceName(tocItem));
    }

    @Override
    public TocItem tocItemByPath(ComponentsRegistry componentsRegistry, TableOfContents toc, Path path) {
        if (path.getFileName().toString().startsWith("index.")) {
            return toc.getIndex();
        }
        return toc.findTocItem(path.toAbsolutePath().getParent().getFileName().toString(), FilePathUtils.fileNameWithoutExtension(path));
    }

    private String filesExtension() {
        return "xml";
    }
}

