/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import znaishaded.net.sourceforge.plantuml.ImageSelection;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.SourceStringReader;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.security.ImageIO;

public class ClipboardLoop {
    public static void runLoop() throws IOException, InterruptedException {
        ClipboardLoop clipboardLoop = new ClipboardLoop();
        while (true) {
            String text;
            if (clipboardLoop.isTextOk(text = clipboardLoop.getClipboardText())) {
                clipboardLoop.runText(text);
            }
            Thread.sleep(10000L);
        }
    }

    public static void runOnce() throws IOException, InterruptedException {
        ClipboardLoop clipboardLoop = new ClipboardLoop();
        String text = clipboardLoop.getClipboardText();
        if (clipboardLoop.isTextOk(text)) {
            clipboardLoop.runText(text);
        } else {
            clipboardLoop.setClipboardImage(new BufferedImage(10, 10, 2));
        }
    }

    private boolean isTextOk(String text) {
        if (text == null) {
            return false;
        }
        return text.startsWith("@start");
    }

    private void runText(String text) throws IOException, InterruptedException {
        Log.info("Getting some text from clipboard");
        SourceStringReader source = new SourceStringReader(text);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DiagramDescription desc = source.outputImage(baos);
        if (desc == null) {
            Log.info("No image generated");
        } else {
            Log.info("Image ok " + desc.getDescription());
            byte[] data = baos.toByteArray();
            baos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            BufferedImage image = ImageIO.read(bais);
            this.setClipboardImage(image);
            bais.close();
            Log.info("Image copied in clipboard");
        }
    }

    private String getClipboardText() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                return text;
            }
        }
        catch (UnsupportedFlavorException e) {
            Log.error(e.toString());
        }
        catch (IOException e) {
            Log.error(e.toString());
        }
        return null;
    }

    private void setClipboardImage(BufferedImage image) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new ImageSelection(image), null);
    }
}

