/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.BlockUml;
import znaishaded.net.sourceforge.plantuml.BlockUmlBuilder;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.FileSystem;
import znaishaded.net.sourceforge.plantuml.ISourceFileReader;
import znaishaded.net.sourceforge.plantuml.SourceFileReaderAbstract;
import znaishaded.net.sourceforge.plantuml.SuggestedFile;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.preproc.FileWithSuffix;
import znaishaded.net.sourceforge.plantuml.security.SFile;

public class SourceFileReaderHardFile
extends SourceFileReaderAbstract
implements ISourceFileReader {
    public SourceFileReaderHardFile(Defines defines, File file, File outputFile, List<String> config, String charset, FileFormatOption fileFormatOption) throws IOException {
        this.file = file;
        this.fileFormatOption = fileFormatOption;
        this.outputFile = outputFile;
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        FileSystem.getInstance().setCurrentDir(SFile.fromFile(file.getAbsoluteFile().getParentFile()));
        SFile parentFile = SFile.fromFile(file.getAbsoluteFile().getParentFile());
        this.builder = new BlockUmlBuilder(config, charset, defines, this.getReader(charset), parentFile, FileWithSuffix.getFileName(file));
    }

    @Override
    protected SuggestedFile getSuggestedFile(BlockUml blockUml) {
        SuggestedFile suggested = SuggestedFile.fromOutputFile(this.outputFile, this.fileFormatOption.getFileFormat());
        return suggested;
    }
}

