/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class FtileCircleSpot
extends AbstractFtile {
    private static final int SIZE = 20;
    private final Swimlane swimlane;
    private final String spot;
    private final FontConfiguration fc;
    private final HColor backColor;

    public FtileCircleSpot(ISkinParam skinParam, Swimlane swimlane, String spot, UFont font, HColor backColor) {
        super(skinParam);
        this.spot = spot;
        this.swimlane = swimlane;
        this.backColor = backColor;
        this.fc = new FontConfiguration(skinParam, FontParam.ACTIVITY, null);
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        HColor borderColor = SkinParamUtils.getColor(this.skinParam(), null, ColorParam.activityBorder);
        HColor backColor = this.backColor == null ? SkinParamUtils.getColor(this.skinParam(), null, ColorParam.activityBackground) : this.backColor;
        UEllipse circle = new UEllipse(20.0, 20.0);
        if (this.skinParam().shadowing(null)) {
            circle.setDeltaShadow(3.0);
        }
        ug.apply(borderColor).apply(backColor.bg()).apply(this.getThickness()).draw(circle);
        ug.apply(this.fc.getColor()).apply(new UTranslate(10.0, 10.0)).draw(new UCenteredCharacter(this.spot.charAt(0), this.fc.getFont()));
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        return new FtileGeometry(20.0, 20.0, 10.0, 0.0, 20.0);
    }
}

