/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.style.Styleable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class FtileDiamondInside
extends AbstractFtile
implements Styleable {
    private final HColor backColor;
    private final HColor borderColor;
    private final Swimlane swimlane;
    private final TextBlock label;
    private final TextBlock west;
    private final TextBlock east;
    private final TextBlock north;
    private final TextBlock south;
    private final double shadowing;

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    @Override
    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public FtileDiamondInside(ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane, TextBlock label) {
        this(skinParam, backColor, borderColor, swimlane, label, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    public FtileDiamondInside withNorth(TextBlock north) {
        return new FtileDiamondInside(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.label, north, this.south, this.west, this.east);
    }

    public FtileDiamondInside withWest(TextBlock west) {
        return new FtileDiamondInside(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, this.south, west, this.east);
    }

    public FtileDiamondInside withEast(TextBlock east) {
        return new FtileDiamondInside(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, this.south, this.west, east);
    }

    public Ftile withWestAndEast(TextBlock tb1, TextBlock tb2) {
        return this.withWest(tb1).withEast(tb2);
    }

    public FtileDiamondInside withSouth(TextBlock south) {
        return new FtileDiamondInside(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.label, this.north, south, this.west, this.east);
    }

    private FtileDiamondInside(ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane, TextBlock label, TextBlock north, TextBlock south, TextBlock west, TextBlock east) {
        super(skinParam);
        if (SkinParam.USE_STYLES()) {
            Style style = this.getDefaultStyleDefinition().getMergedStyle(skinParam.getCurrentStyleBuilder());
            this.borderColor = style.value(PName.LineColor).asColor(this.getIHtmlColorSet());
            this.backColor = style.value(PName.BackGroundColor).asColor(this.getIHtmlColorSet());
            this.shadowing = style.value(PName.Shadowing).asDouble();
        } else {
            this.backColor = backColor;
            this.borderColor = borderColor;
            this.shadowing = this.skinParam().shadowing(null) ? 3.0 : 0.0;
        }
        this.swimlane = swimlane;
        this.label = label;
        this.west = west;
        this.east = east;
        this.north = north;
        this.south = south;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimLabel = this.label.calculateDimension(stringBounder);
        FtileGeometry dimTotal = this.calculateDimensionAlone(stringBounder);
        ug = ug.apply(this.borderColor).apply(this.getThickness()).apply(this.backColor.bg());
        ug.draw(Diamond.asPolygon(this.shadowing, ((Dimension2D)dimTotal).getWidth(), ((Dimension2D)dimTotal).getHeight()));
        this.north.drawU(ug.apply(new UTranslate(4.0 + ((Dimension2D)dimTotal).getWidth() / 2.0, ((Dimension2D)dimTotal).getHeight())));
        this.south.drawU(ug.apply(new UTranslate(4.0 + ((Dimension2D)dimTotal).getWidth() / 2.0, ((Dimension2D)dimTotal).getHeight())));
        double lx = (((Dimension2D)dimTotal).getWidth() - dimLabel.getWidth()) / 2.0;
        double ly = (((Dimension2D)dimTotal).getHeight() - dimLabel.getHeight()) / 2.0;
        this.label.drawU(ug.apply(new UTranslate(lx, ly)));
        Dimension2D dimWest = this.west.calculateDimension(stringBounder);
        this.west.drawU(ug.apply(new UTranslate(-dimWest.getWidth(), -dimWest.getHeight() + ((Dimension2D)dimTotal).getHeight() / 2.0)));
        Dimension2D dimEast = this.east.calculateDimension(stringBounder);
        this.east.drawU(ug.apply(new UTranslate(((Dimension2D)dimTotal).getWidth(), -dimEast.getHeight() + ((Dimension2D)dimTotal).getHeight() / 2.0)));
    }

    private FtileGeometry calculateDimensionAlone(StringBounder stringBounder) {
        Dimension2D dimLabel = this.label.calculateDimension(stringBounder);
        Dimension2D dim = dimLabel.getWidth() == 0.0 || dimLabel.getHeight() == 0.0 ? new Dimension2DDouble(24.0, 24.0) : Dimension2DDouble.delta(Dimension2DDouble.atLeast(dimLabel, 24.0, 24.0), 24.0, 0.0);
        return new FtileGeometry(dim, dim.getWidth() / 2.0, 0.0, dim.getHeight());
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry dimDiamonAlone = this.calculateDimensionAlone(stringBounder);
        Dimension2D dimWest = this.west.calculateDimension(stringBounder);
        Dimension2D dimEast = this.east.calculateDimension(stringBounder);
        double northHeight = this.north.calculateDimension(stringBounder).getHeight();
        return dimDiamonAlone.incHeight(northHeight);
    }

    public double getEastLabelWidth(StringBounder stringBounder) {
        Dimension2D dimEast = this.east.calculateDimension(stringBounder);
        return dimEast.getWidth();
    }

    public double getSouthLabelHeight(StringBounder stringBounder) {
        Dimension2D dimSouth = this.south.calculateDimension(stringBounder);
        return dimSouth.getHeight();
    }
}

