/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.core.Diagram;

public abstract class CommandMultilinesBracket<S extends Diagram>
implements Command<S> {
    private final Pattern2 starting;

    public CommandMultilinesBracket(String patternStart) {
        if (!patternStart.startsWith("(?i)^") || !patternStart.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + patternStart);
        }
        this.starting = MyPattern.cmpile(patternStart);
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"BRACKET: " + this.starting.pattern()};
    }

    protected void actionIfCommandValid() {
    }

    protected final Pattern2 getStartingPattern() {
        return this.starting;
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        Matcher2 m1 = this.starting.matcher(lines.getFirst().getTrimmed().getString());
        if (!m1.matches()) {
            return CommandControl.NOT_OK;
        }
        if (lines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        int level = 1;
        for (StringLocated cs : lines.subExtract(1, 0)) {
            String s2 = cs.getTrimmed().getString();
            if (!this.isLineConsistent(s2, level)) {
                return CommandControl.NOT_OK;
            }
            if (s2.endsWith("{")) {
                ++level;
            }
            if (s2.endsWith("}")) {
                --level;
            }
            if (level >= 0) continue;
            return CommandControl.NOT_OK;
        }
        if (level != 0) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    protected abstract boolean isLineConsistent(String var1, int var2);
}

