/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;

public class CommandPragma
extends SingleLineCommand2<UmlDiagram> {
    public CommandPragma() {
        super(CommandPragma.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPragma.class.getName(), RegexLeaf.start(), new RegexLeaf("!pragma"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "([A-Za-z_][A-Za-z_0-9]*)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("VALUE", "(.*)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(UmlDiagram system, LineLocation location, RegexResult arg) {
        String name = StringUtils.goLowerCase(arg.get("NAME", 0));
        String value = arg.get("VALUE", 0);
        system.getPragma().define(name, value);
        if (name.equalsIgnoreCase("graphviz_dot") && value.equalsIgnoreCase("jdot")) {
            system.setUseJDot(true);
        }
        if (name.equalsIgnoreCase("graphviz_dot") && value.equalsIgnoreCase("vizjs")) {
            system.getSkinParam().setUseVizJs(true);
        }
        return CommandExecutionResult.ok();
    }
}

