/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.atom;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.creole.atom.AbstractAtom;
import znaishaded.net.sourceforge.plantuml.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class Bullet
extends AbstractAtom
implements Atom {
    private final FontConfiguration fontConfiguration;
    private final int order;

    public Bullet(FontConfiguration fontConfiguration, int order) {
        this.fontConfiguration = fontConfiguration;
        this.order = order;
    }

    private double getWidth(StringBounder stringBounder) {
        Dimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), "W");
        return dim.getWidth() * (double)(this.order + 1);
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.order == 0) {
            this.drawU0(ug);
        } else {
            this.drawU1(ug);
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.order == 0) {
            return this.calculateDimension0(stringBounder);
        }
        return this.calculateDimension1(stringBounder);
    }

    private void drawU0(UGraphic ug) {
        HColor color = this.fontConfiguration.getColor();
        ug = ug.apply(color).apply(color.bg()).apply(new UStroke(0.0));
        ug = ug.apply(UTranslate.dx(3.0));
        ug.draw(new UEllipse(5.0, 5.0));
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return -5.0;
    }

    private Dimension2D calculateDimension0(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getWidth(stringBounder), 5.0);
    }

    private void drawU1(UGraphic ug) {
        HColor color = this.fontConfiguration.getColor();
        ug = ug.apply(color).apply(color.bg()).apply(new UStroke(0.0));
        double width = this.getWidth(ug.getStringBounder());
        ug = ug.apply(UTranslate.dx(width - 5.0));
        ug.draw(new URectangle(3.5, 3.5));
    }

    private Dimension2D calculateDimension1(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getWidth(stringBounder), 3.0);
    }
}

