/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.geom.InflateData;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;
import znaishaded.net.sourceforge.plantuml.geom.Point2DIntComparatorDistance;

public class InflationTransform {
    private final List<InflateData> inflateX = new ArrayList<InflateData>();
    private final List<InflateData> inflateY = new ArrayList<InflateData>();

    public void addInflationX(int xpos, int inflation) {
        InflationTransform.add(this.inflateX, xpos, inflation);
    }

    public String toString() {
        return "inflateX = " + this.inflateX + " inflateY = " + this.inflateY;
    }

    public void addInflationY(int ypos, int inflation) {
        InflationTransform.add(this.inflateY, ypos, inflation);
    }

    private static void add(List<InflateData> list, int ypos, int inflation) {
        ListIterator<InflateData> it = list.listIterator();
        while (it.hasNext()) {
            InflateData cur = it.next();
            if (cur.getPos() != ypos) continue;
            it.set(new InflateData(ypos, Math.max(inflation, cur.getInflation())));
            return;
        }
        list.add(new InflateData(ypos, inflation));
        Collections.sort(list);
    }

    Collection<Point2DInt> cutPoints(LineSegmentInt original) {
        Point2DInt inter;
        TreeSet<Point2DInt> result = new TreeSet<Point2DInt>(new Point2DIntComparatorDistance(original.getP1()));
        if (!original.isHorizontal()) {
            for (InflateData x : this.inflateX) {
                LineSegmentInt vertical = new LineSegmentInt(x.getPos(), original.getMinY(), x.getPos(), original.getMaxY());
                inter = original.getSegIntersection(vertical);
                if (inter == null) continue;
                result.add(inter);
            }
        }
        if (!original.isVertical()) {
            for (InflateData y : this.inflateY) {
                LineSegmentInt horizontal = new LineSegmentInt(original.getMinX(), y.getPos(), original.getMaxX(), y.getPos());
                inter = original.getSegIntersection(horizontal);
                if (inter == null) continue;
                result.add(inter);
            }
        }
        return result;
    }

    Collection<LineSegmentInt> cutSegments(LineSegmentInt original) {
        ArrayList<LineSegmentInt> result = new ArrayList<LineSegmentInt>();
        Point2DInt cur = original.getP1();
        Collection<Point2DInt> cutPoints = this.cutPoints(original);
        for (Point2DInt inter : cutPoints) {
            if (cur.equals(inter)) continue;
            result.add(new LineSegmentInt(cur, inter));
            cur = inter;
        }
        if (!cur.equals(original.getP2())) {
            result.add(new LineSegmentInt(cur, original.getP2()));
        }
        return result;
    }

    Collection<LineSegmentInt> cutSegments(Collection<LineSegmentInt> segments) {
        ArrayList<LineSegmentInt> result = new ArrayList<LineSegmentInt>();
        for (LineSegmentInt seg : segments) {
            result.addAll(this.cutSegments(seg));
        }
        return result;
    }

    private LineSegmentInt inflateSegment(LineSegmentInt seg) {
        if (this.isOnGrid(seg.getP1()) || this.isOnGrid(seg.getP2())) {
            return new LineSegmentInt(this.inflatePoint2DInt(seg.getP1()), this.inflatePoint2DInt(seg.getP2()));
        }
        for (InflateData x : this.inflateX) {
            seg = seg.inflateXAlpha(x);
        }
        for (InflateData y : this.inflateY) {
            seg = seg.inflateYAlpha(y);
        }
        return seg;
    }

    private boolean isOnGrid(Point2DInt point) {
        boolean onGrid = false;
        for (InflateData x : this.inflateX) {
            if (point.getX() != (double)x.getPos()) continue;
            onGrid = true;
        }
        if (!onGrid) {
            return false;
        }
        for (InflateData y : this.inflateY) {
            if (point.getY() != (double)y.getPos()) continue;
            return true;
        }
        return false;
    }

    public Point2DInt inflatePoint2DInt(Point2DInt point) {
        for (InflateData x : this.inflateX) {
            point = point.inflateX(x);
        }
        for (InflateData y : this.inflateY) {
            point = point.inflateY(y);
        }
        return point;
    }

    List<LineSegmentInt> inflateSegmentCollection(Collection<LineSegmentInt> segments) {
        ArrayList<LineSegmentInt> result = new ArrayList<LineSegmentInt>();
        for (LineSegmentInt seg : segments) {
            result.add(this.inflateSegment(seg));
        }
        return result;
    }

    public List<LineSegmentInt> inflate(Collection<LineSegmentInt> segments) {
        ArrayList<LineSegmentInt> result = new ArrayList<LineSegmentInt>();
        LineSegmentInt last = null;
        Collection<LineSegmentInt> cutSegments = this.cutSegments(segments);
        for (LineSegmentInt seg : this.inflateSegmentCollection(cutSegments)) {
            if (last != null && !last.getP2().equals(seg.getP1())) {
                result.add(new LineSegmentInt(last.getP2(), seg.getP1()));
            }
            result.add(seg);
            last = seg;
        }
        return result;
    }
}

