/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.graph.ALink;
import znaishaded.net.sourceforge.plantuml.graph.ANode;
import znaishaded.net.sourceforge.plantuml.graph.LenghtLinkComparator;
import znaishaded.net.sourceforge.plantuml.graph.Move;

public class Board {
    private final List<ALink> links;
    private final Map<ALink, Integer> initialDirection;
    private final Map<ANode, Integer> nodesCols = new LinkedHashMap<ANode, Integer>();
    private int hashcodeValue;
    private boolean hashcodeComputed = false;

    private Board(Board old) {
        this.links = old.links;
        this.initialDirection = old.initialDirection;
        this.nodesCols.putAll(old.nodesCols);
    }

    public Comparator<ALink> getLinkComparator() {
        return new LenghtLinkComparator(this.nodesCols);
    }

    public boolean equals(Object o) {
        Board other = (Board)o;
        if (this.links != other.links) {
            return false;
        }
        Iterator<Integer> it1 = this.nodesCols.values().iterator();
        Iterator<Integer> it2 = other.nodesCols.values().iterator();
        assert (this.nodesCols.size() == other.nodesCols.size());
        while (it1.hasNext()) {
            if (it1.next().equals(it2.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashcodeComputed) {
            return this.hashcodeValue;
        }
        this.hashcodeValue = 13;
        for (Integer i : this.nodesCols.values()) {
            this.hashcodeValue = this.hashcodeValue * 17 + i;
        }
        this.hashcodeComputed = true;
        return this.hashcodeValue;
    }

    public void normalize() {
        int minRow = Integer.MAX_VALUE;
        int minCol = Integer.MAX_VALUE;
        int maxRow = Integer.MIN_VALUE;
        int maxCol = Integer.MIN_VALUE;
        for (Map.Entry<ANode, Integer> ent : this.nodesCols.entrySet()) {
            minRow = Math.min(minRow, ent.getKey().getRow());
            maxRow = Math.max(maxRow, ent.getKey().getRow());
            minCol = Math.min(minCol, ent.getValue());
            maxCol = Math.max(maxCol, ent.getValue());
        }
        for (Map.Entry<ANode, Integer> ent : this.nodesCols.entrySet()) {
            if (minRow != 0) {
                ent.getKey().setRow(ent.getKey().getRow() - minRow);
            }
            if (minCol == 0) continue;
            ent.setValue(ent.getValue() - minCol);
        }
    }

    private void normalizeCol() {
        int minCol = Collections.min(this.nodesCols.values());
        if (minCol != 0) {
            for (Map.Entry<ANode, Integer> ent : this.nodesCols.entrySet()) {
                ent.setValue(ent.getValue() - minCol);
            }
        }
    }

    void internalMove(String code, int newCol) {
        this.hashcodeComputed = false;
        for (ANode n : this.nodesCols.keySet()) {
            if (!n.getCode().equals(code)) continue;
            this.nodesCols.put(n, newCol);
            return;
        }
    }

    public Board copy() {
        return new Board(this);
    }

    public Board(List<ANode> nodes, List<ALink> links) {
        for (ANode n : nodes) {
            this.addInRow(n);
        }
        this.links = Collections.unmodifiableList(new ArrayList<ALink>(links));
        this.initialDirection = new HashMap<ALink, Integer>();
        for (ALink link : links) {
            this.initialDirection.put(link, this.getDirection(link));
        }
    }

    public int getInitialDirection(ALink link) {
        return this.initialDirection.get(link);
    }

    public int getDirection(ALink link) {
        return this.getCol(link.getNode2()) - this.getCol(link.getNode1());
    }

    private void addInRow(ANode n) {
        this.hashcodeComputed = false;
        int col = 0;
        while (true) {
            if (this.getNodeAt(n.getRow(), col) == null) {
                this.nodesCols.put(n, col);
                assert (this.getNodeAt(n.getRow(), col) == n);
                return;
            }
            ++col;
        }
    }

    public Collection<ANode> getNodes() {
        return Collections.unmodifiableCollection(this.nodesCols.keySet());
    }

    public Collection<ANode> getNodesInRow(int row) {
        ArrayList<ANode> result = new ArrayList<ANode>();
        for (ANode n : this.nodesCols.keySet()) {
            if (n.getRow() != row) continue;
            result.add(n);
        }
        return Collections.unmodifiableCollection(result);
    }

    public final List<? extends ALink> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public int getCol(ANode n) {
        return this.nodesCols.get(n);
    }

    public void applyMove(Move move) {
        ANode piece = this.getNodeAt(move.getRow(), move.getCol());
        if (piece == null) {
            throw new IllegalArgumentException();
        }
        ANode piece2 = this.getNodeAt(move.getRow(), move.getNewCol());
        this.nodesCols.put(piece, move.getNewCol());
        if (piece2 != null) {
            this.nodesCols.put(piece2, move.getCol());
        }
        this.normalizeCol();
        this.hashcodeComputed = false;
    }

    public Collection<Move> getAllPossibleMoves() {
        ArrayList<Move> result = new ArrayList<Move>();
        for (Map.Entry<ANode, Integer> ent : this.nodesCols.entrySet()) {
            int row = ent.getKey().getRow();
            int col = ent.getValue();
            result.add(new Move(row, col, -1));
            result.add(new Move(row, col, 1));
        }
        return result;
    }

    public ANode getNodeAt(int row, int col) {
        for (Map.Entry<ANode, Integer> ent : this.nodesCols.entrySet()) {
            if (ent.getKey().getRow() != row || ent.getValue() != col) continue;
            return ent.getKey();
        }
        return null;
    }

    public Set<ANode> getConnectedNodes(ANode root, int level) {
        if (level < 0) {
            throw new IllegalArgumentException();
        }
        if (level == 0) {
            return Collections.singleton(root);
        }
        HashSet<ANode> result = new HashSet<ANode>();
        if (level == 1) {
            for (ALink link : this.links) {
                if (link.getNode1() == root) {
                    result.add(link.getNode2());
                    continue;
                }
                if (link.getNode2() != root) continue;
                result.add(link.getNode1());
            }
        } else {
            for (ANode n : this.getConnectedNodes(root, level - 1)) {
                result.addAll(this.getConnectedNodes(n, 1));
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<ALink> getAllLinks(Set<ANode> nodes) {
        HashSet<ALink> result = new HashSet<ALink>();
        for (ALink link : this.links) {
            if (!nodes.contains(link.getNode1()) && !nodes.contains(link.getNode2())) continue;
            result.add(link);
        }
        return Collections.unmodifiableSet(result);
    }
}

