/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

class TextBlockMinWidth
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock textBlock;
    private final double minWidth;
    private final HorizontalAlignment horizontalAlignment;

    TextBlockMinWidth(TextBlock textBlock, double minWidth, HorizontalAlignment horizontalAlignment) {
        this.textBlock = textBlock;
        this.minWidth = minWidth;
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        return Dimension2DDouble.atLeast(dim, this.minWidth, 0.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.horizontalAlignment == HorizontalAlignment.LEFT) {
            this.textBlock.drawU(ug);
        } else if (this.horizontalAlignment == HorizontalAlignment.CENTER) {
            Dimension2D dimText = this.textBlock.calculateDimension(ug.getStringBounder());
            Dimension2D dimFull = this.calculateDimension(ug.getStringBounder());
            double diffx = dimFull.getWidth() - dimText.getWidth();
            this.textBlock.drawU(ug.apply(UTranslate.dx(diffx / 2.0)));
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT) {
            Dimension2D dimText = this.textBlock.calculateDimension(ug.getStringBounder());
            Dimension2D dimFull = this.calculateDimension(ug.getStringBounder());
            double diffx = dimFull.getWidth() - dimText.getWidth();
            this.textBlock.drawU(ug.apply(UTranslate.dx(diffx)));
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

