/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.hector.SkeletonConfiguration;
import znaishaded.net.sourceforge.plantuml.hector.SkeletonConfigurationComparator;
import znaishaded.net.sourceforge.plantuml.hector.SkeletonConfigurationEvaluator;

public class SkeletonConfigurationSet
implements Iterable<SkeletonConfiguration> {
    private final List<SkeletonConfiguration> all;
    private final SkeletonConfigurationComparator comparator;
    private final int limitSize;

    public SkeletonConfigurationSet(int limitSize, SkeletonConfigurationEvaluator evaluator) {
        this.comparator = new SkeletonConfigurationComparator(evaluator);
        this.all = new ArrayList<SkeletonConfiguration>();
        this.limitSize = limitSize;
    }

    public void add(SkeletonConfiguration skeletonConfiguration) {
        this.all.add(skeletonConfiguration);
        this.sortAndTruncate();
    }

    public void addAll(Collection<SkeletonConfiguration> others) {
        this.all.addAll(others);
        this.sortAndTruncate();
    }

    private void sortAndTruncate() {
        Collections.sort(this.all, this.comparator);
        while (this.all.size() > this.limitSize) {
            this.all.remove(this.all.size() - 1);
        }
    }

    public String toString() {
        return this.all.toString();
    }

    public int size() {
        return this.all.size();
    }

    @Override
    public Iterator<SkeletonConfiguration> iterator() {
        return new ArrayList<SkeletonConfiguration>(this.all).iterator();
    }

    public SkeletonConfiguration first() {
        return this.all.get(0);
    }
}

