/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.nwdiag;

import java.util.LinkedHashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.ComponentStyle;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.nwdiag.LinkedElement;
import znaishaded.net.sourceforge.plantuml.nwdiag.Network;
import znaishaded.net.sourceforge.plantuml.skin.ActorStyle;
import znaishaded.net.sourceforge.plantuml.svek.PackageStyle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class DiagElement {
    private USymbol shape = USymbol.RECTANGLE;
    private final String name;
    private String description;
    private final Network mainNetwork;
    private final ISkinSimple spriteContainer;

    public String toString() {
        return this.name;
    }

    public DiagElement(String name, Network network, ISkinSimple spriteContainer) {
        this.description = name;
        this.mainNetwork = network;
        this.name = name;
        this.spriteContainer = spriteContainer;
    }

    private TextBlock toTextBlock(String s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.length() == 0) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        s2 = s2.replace(", ", "\\n");
        return Display.getWithNewlines(s2).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.spriteContainer);
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    public LinkedElement asTextBlock(Map<Network, String> conns, Network next) {
        LinkedHashMap<Network, TextBlock> conns2 = new LinkedHashMap<Network, TextBlock>();
        for (Map.Entry<Network, String> ent : conns.entrySet()) {
            conns2.put(ent.getKey(), this.toTextBlock(ent.getValue()));
        }
        SymbolContext symbolContext = new SymbolContext(ColorParam.activityBackground.getDefaultValue(), ColorParam.activityBorder.getDefaultValue()).withShadow(3.0);
        TextBlock desc = this.toTextBlock(this.description);
        TextBlock box = this.shape.asSmall(TextBlockUtils.empty(0.0, 0.0), desc, TextBlockUtils.empty(0.0, 0.0), symbolContext, HorizontalAlignment.CENTER);
        return new LinkedElement(this, box, this.mainNetwork, next, conns2);
    }

    public String getDescription() {
        return this.description;
    }

    public final Network getMainNetwork() {
        return this.mainNetwork;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public final void setShape(String shapeName) {
        USymbol shapeFromString = USymbol.fromString(shapeName, ActorStyle.STICKMAN, ComponentStyle.RECTANGLE, PackageStyle.RECTANGLE);
        if (shapeFromString != null) {
            this.shape = shapeFromString;
        }
    }
}

