/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.nwdiag;

import java.awt.geom.Dimension2D;
import java.util.Map;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.nwdiag.DiagElement;
import znaishaded.net.sourceforge.plantuml.nwdiag.Network;
import znaishaded.net.sourceforge.plantuml.nwdiag.VerticalLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class LinkedElement {
    private final TextBlock box;
    private final Network network;
    private final Network next;
    private final DiagElement element;
    private final Map<Network, TextBlock> conns;
    private final double marginAd = 10.0;
    private final double marginBox = 15.0;

    public LinkedElement(DiagElement element, TextBlock box, Network network, Network next, Map<Network, TextBlock> conns) {
        this.box = box;
        this.network = network;
        this.element = element;
        this.conns = conns;
        this.next = next;
    }

    public boolean isLinkedTo(Network some) {
        return this.conns.containsKey(some);
    }

    public MinMax getMinMax(StringBounder stringBounder, double width, double height) {
        double xMiddle = width / 2.0;
        double yMiddle = height / 2.0;
        Dimension2D dimBox = this.box.calculateDimension(stringBounder);
        double x1 = xMiddle - dimBox.getWidth() / 2.0;
        double y1 = yMiddle - dimBox.getHeight() / 2.0;
        double x2 = xMiddle + dimBox.getWidth() / 2.0;
        double y2 = yMiddle + dimBox.getHeight() / 2.0;
        return MinMax.getEmpty(false).addPoint(x1 - 5.0, y1 - 5.0).addPoint(x2 + 5.0, y2 + 5.0);
    }

    public void drawMe(UGraphic ug, double width, double height) {
        double xMiddle = width / 2.0;
        double yMiddle = height / 2.0;
        this.drawCenter(ug, this.box, xMiddle, yMiddle);
    }

    public void drawLinks(UGraphic ug, double width, double height, Map<Network, Double> pos) {
        double ynet1 = pos.get(this.network);
        double yMiddle = height / 2.0;
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimBox = this.box.calculateDimension(stringBounder);
        double alpha = yMiddle - dimBox.getHeight() / 2.0;
        HColor color = ColorParam.activityBorder.getDefaultValue();
        ug = ug.apply(color);
        double xMiddle = width / 2.0;
        TreeSet<Double> skip = new TreeSet<Double>(pos.values());
        new VerticalLine(ynet1 + 5.0, ynet1 + alpha, skip).drawU(ug.apply(UTranslate.dx(xMiddle)));
        this.drawCenter(ug, this.link1(), xMiddle, ynet1 + alpha / 2.0);
        double seven = 7.0;
        double x = xMiddle - (double)(this.conns.size() - 2) * 7.0 / 2.0;
        boolean first = true;
        for (Map.Entry<Network, TextBlock> ent : this.conns.entrySet()) {
            if (ent.getKey() == this.network) continue;
            Double ynet2 = pos.get(ent.getKey());
            new VerticalLine(ynet1 + yMiddle + dimBox.getHeight() / 2.0, ynet2, skip).drawU(ug.apply(UTranslate.dx(x)));
            double xtext = first && this.conns.size() > 2 ? x - ent.getValue().calculateDimension(stringBounder).getWidth() / 2.0 : x;
            this.drawCenter(ug, ent.getValue(), xtext, ynet2 - alpha / 2.0);
            x += 7.0;
            first = false;
        }
    }

    private TextBlock link1() {
        return this.conns.get(this.network);
    }

    private TextBlock link2() {
        if (this.next == null) {
            return null;
        }
        return this.conns.get(this.next);
    }

    private void drawCenter(UGraphic ug, TextBlock block, double x, double y) {
        Dimension2D dim = block.calculateDimension(ug.getStringBounder());
        block.drawU(ug.apply(new UTranslate(x - dim.getWidth() / 2.0, y - dim.getHeight() / 2.0)));
    }

    public Dimension2D naturalDimension(StringBounder stringBounder) {
        Dimension2D dim1 = this.link1().calculateDimension(stringBounder);
        Dimension2D dimBox = this.box.calculateDimension(stringBounder);
        Dimension2D dim2 = this.link2() == null ? new Dimension2DDouble(0.0, 0.0) : this.link2().calculateDimension(stringBounder);
        double width = MathUtils.max(dim1.getWidth() + 20.0, dimBox.getWidth() + 30.0, dim2.getWidth() + 20.0);
        double height = dim1.getHeight() + 20.0 + dimBox.getHeight() + 30.0 + dim2.getHeight() + 20.0;
        return new Dimension2DDouble(width, height);
    }

    public final Network getNetwork() {
        return this.network;
    }

    public final DiagElement getElement() {
        return this.element;
    }
}

