/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.openiconic;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.openiconic.OpenIcon;
import znaishaded.net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PSystemOpenIconic
extends AbstractPSystem {
    private final String iconName;
    private final double factor;

    public PSystemOpenIconic(String iconName, double factor) {
        this.iconName = iconName;
        this.factor = factor;
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        int margin2;
        int margin1;
        OpenIcon icon = OpenIcon.retrieve(this.iconName);
        if (SkinParam.USE_STYLES()) {
            margin1 = SkinParam.zeroMargin(5);
            margin2 = SkinParam.zeroMargin(5);
        } else {
            margin1 = 5;
            margin2 = 5;
        }
        ImageBuilder imageBuilder = ImageBuilder.buildB(new ColorMapperIdentity(), false, ClockwiseTopRightBottomLeft.margin1margin2(margin1, margin2), null, null, null, 1.0, null);
        imageBuilder.setUDrawable(icon.asTextBlock(HColorUtils.BLACK, this.factor));
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Open iconic)");
    }
}

