/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.real;

import znaishaded.net.sourceforge.plantuml.real.AbstractReal;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.real.RealMoveable;

class RealMiddle
extends AbstractReal
implements Real {
    private final RealMoveable p1;
    private final RealMoveable p2;
    private final double delta;

    private RealMiddle(RealMoveable p1, RealMoveable p2, double delta) {
        super(p1.getLine());
        this.p1 = p1;
        this.p2 = p2;
        this.delta = delta;
    }

    RealMiddle(RealMoveable p1, RealMoveable p2) {
        this(p1, p2, 0.0);
    }

    @Override
    double getCurrentValueInternal() {
        return (this.p1.getCurrentValue() + this.p2.getCurrentValue()) / 2.0 + this.delta;
    }

    @Override
    public Real addFixed(double diff) {
        return new RealMiddle(this.p1, this.p2, this.delta + diff);
    }

    @Override
    public Real addAtLeast(double delta) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureBiggerThan(Real other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "[Middle " + this.p1.getName() + " and " + this.p2.getName() + "]";
    }

    @Override
    public void printCreationStackTrace() {
        throw new UnsupportedOperationException();
    }
}

