/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.salt.element.Element;
import znaishaded.net.sourceforge.plantuml.salt.element.ListWidth;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElementTreeEntry {
    private final Element firstElement;
    private final int level;
    private final List<Element> otherElements = new ArrayList<Element>();

    public ElementTreeEntry(int level, Element elmt) {
        this.firstElement = elmt;
        this.level = level;
    }

    public void addCell(Element elmt) {
        this.otherElements.add(elmt);
    }

    public Dimension2D getPreferredDimensionFirstCell(StringBounder stringBounder) {
        return Dimension2DDouble.delta(this.firstElement.getPreferredDimension(stringBounder, 0.0, 0.0), this.getXDelta(), 0.0);
    }

    public ListWidth getPreferredDimensionOtherCell(StringBounder stringBounder) {
        ListWidth result = new ListWidth();
        for (Element element : this.otherElements) {
            result.add(element.getPreferredDimension(stringBounder, 0.0, 0.0).getWidth());
        }
        return result;
    }

    public double getXDelta() {
        return this.level * 10;
    }

    public void drawFirstCell(UGraphic ug, double x, double y) {
        this.firstElement.drawU(ug.apply(new UTranslate(x + this.getXDelta(), y)), 0, null);
    }

    public void drawSecondCell(UGraphic ug, double x, double y, ListWidth otherWidth, double margin) {
        Iterator<Double> it = otherWidth.iterator();
        for (Element element : this.otherElements) {
            element.drawU(ug.apply(new UTranslate(x, y)), 0, null);
            x += it.next() + margin;
        }
    }
}

