/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.security;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.security.SecurityProfile;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;

public class SURL {
    private final URL internal;
    private static final ExecutorService exe = Executors.newCachedThreadPool();
    private static final Map<String, Long> badHosts = new ConcurrentHashMap<String, Long>();

    private SURL(String src) throws MalformedURLException {
        this(new URL(src));
    }

    private SURL(URL url) {
        this.internal = url;
    }

    public static SURL create(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            try {
                return new SURL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static SURL create(URL url) {
        if (url == null) {
            return null;
        }
        return new SURL(url);
    }

    public String toString() {
        return this.internal.toString();
    }

    private boolean isUrlOk() {
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.SANDBOX) {
            return false;
        }
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.LEGACY) {
            return true;
        }
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
            return true;
        }
        if (this.isInAllowList()) {
            return true;
        }
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.INTERNET) {
            if (this.pureIP(this.cleanPath(this.internal.toString()))) {
                return false;
            }
            int port = this.internal.getPort();
            if (port == 80 || port == 443 || port == -1) {
                return true;
            }
        }
        return false;
    }

    private boolean pureIP(String full) {
        return full.matches("^https?://\\d+\\.\\d+\\.\\d+\\.\\d+.*");
    }

    private boolean isInAllowList() {
        String full = this.cleanPath(this.internal.toString());
        for (String allow : this.getAllowList()) {
            if (!full.startsWith(this.cleanPath(allow))) continue;
            return true;
        }
        return false;
    }

    private String cleanPath(String path) {
        path = path.trim().toLowerCase(Locale.US);
        path = path.replace(":80/", "");
        path = path.replace(":443/", "");
        return path;
    }

    private List<String> getAllowList() {
        String env = SecurityUtils.getenv("plantuml.allowlist.url");
        if (env == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(env).split(";"));
    }

    public byte[] getBytes() {
        if (!this.isUrlOk()) {
            return null;
        }
        String host = this.internal.getHost();
        Long bad = badHosts.get(host);
        if (bad != null) {
            long duration = System.currentTimeMillis() - bad;
            if (duration < 60000L) {
                return null;
            }
            badHosts.remove(host);
        }
        Future<byte[]> result = exe.submit(new Callable<byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] call() throws IOException {
                try (InputStream input = null;){
                    int read;
                    URLConnection connection = SURL.this.internal.openConnection();
                    if (connection == null) {
                        byte[] byArray = null;
                        return byArray;
                    }
                    input = connection.getInputStream();
                    ByteArrayOutputStream image = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((read = input.read(buffer)) > 0) {
                        image.write(buffer, 0, read);
                    }
                    image.close();
                    byte[] byArray = image.toByteArray();
                    return byArray;
                }
            }
        });
        try {
            byte[] data = result.get(SecurityUtils.getSecurityProfile().getTimeout(), TimeUnit.MILLISECONDS);
            if (data != null) {
                return data;
            }
        }
        catch (Exception e) {
            System.err.println("issue " + host + " " + e);
        }
        badHosts.put(host, System.currentTimeMillis());
        return null;
    }

    public InputStream openStream() {
        byte[] data;
        if (this.isUrlOk() && (data = this.getBytes()) != null) {
            return new ByteArrayInputStream(data);
        }
        return null;
    }

    public BufferedImage readRasterImageFromURL() {
        if (this.isUrlOk()) {
            try {
                ImageIcon tmp = new ImageIcon(this.internal);
                return SecurityUtils.readRasterImage(tmp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

