/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class Reference
extends AbstractEvent
implements Event {
    private final List<Participant> participants;
    private final Url url;
    private final HColor backColorGeneral;
    private final HColor backColorElement;
    private final Display strings;
    private final Style style;
    private final Style styleHeader;

    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.reference);
    }

    private StyleSignature getHeaderStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, SName.sequenceDiagram, SName.referenceHeader);
    }

    public Style[] getUsedStyles() {
        return new Style[]{this.style, this.styleHeader == null ? this.styleHeader : this.styleHeader.eventuallyOverride(PName.BackGroundColor, this.backColorElement)};
    }

    public Reference(List<Participant> participants, Url url, Display strings, HColor backColorGeneral, HColor backColorElement, StyleBuilder styleBuilder) {
        this.participants = participants;
        this.url = url;
        this.strings = strings;
        this.backColorGeneral = backColorGeneral;
        this.backColorElement = backColorElement;
        this.style = this.getDefaultStyleDefinition().getMergedStyle(styleBuilder);
        this.styleHeader = this.getHeaderStyleDefinition().getMergedStyle(styleBuilder);
    }

    public List<Participant> getParticipant() {
        return Collections.unmodifiableList(this.participants);
    }

    public Display getStrings() {
        return this.strings;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return this.participants.contains(someone);
    }

    @Override
    public final Url getUrl() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        return this.url != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Participant> it = this.participants.iterator();
        while (it.hasNext()) {
            sb.append(it.next().getCode());
            if (!it.hasNext()) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public final HColor getBackColorGeneral() {
        return this.backColorGeneral;
    }

    public final HColor getBackColorElement() {
        return this.backColorElement;
    }
}

