/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.command;

import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Reference;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class CommandReferenceMultilinesOverSeveral
extends CommandMultilines<SequenceDiagram> {
    public CommandReferenceMultilinesOverSeveral() {
        super("(?i)^ref(#\\w+)?[%s]+over[%s]+((?:[\\p{L}0-9_.@]+|[%g][^%g]+[%g])(?:[%s]*,[%s]*(?:[\\p{L}0-9_.@]+|[%g][^%g]+[%g]))*)[%s]*(#\\w+)?$");
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?(ref)?$";
    }

    @Override
    public CommandExecutionResult execute(SequenceDiagram diagram, BlocLines lines) {
        List<String> line0 = StringUtils.getSplit(this.getStartingPattern(), lines.getFirst().getTrimmed().getString());
        HColor backColorElement = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(line0.get(0));
        List<String> participants = StringUtils.splitComma(line0.get(1));
        ArrayList<Participant> p = new ArrayList<Participant>();
        for (String s2 : participants) {
            p.add(diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s2)));
        }
        lines = lines.subExtract(1, 1);
        lines = lines.removeEmptyColumns();
        Display strings = lines.toDisplay();
        Url u = null;
        if (strings.size() > 0) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            u = urlBuilder.getUrl(strings.get(0).toString());
        }
        if (u != null) {
            strings = strings.subList(1, strings.size());
        }
        HColor backColorGeneral = null;
        Reference ref = new Reference(p, u, strings, backColorGeneral, backColorElement, diagram.getSkinParam().getCurrentStyleBuilder());
        diagram.addReference(ref);
        return CommandExecutionResult.ok();
    }
}

