/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.command;

import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandUrl
extends SingleLineCommand2<SequenceDiagram> {
    public CommandUrl() {
        super(CommandUrl.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandUrl.class.getName(), RegexLeaf.start(), new RegexLeaf("url"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("of|for")), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([\\p{L}0-9_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceOneOrMore(), new RegexOptional((IRegex)new RegexLeaf("is")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) {
        String code = arg.get("CODE", 0);
        String urlString = arg.get("URL", 0);
        Participant p = diagram.getOrCreateParticipant(code);
        UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
        Url url = urlBuilder.getUrl(urlString);
        p.setUrl(url);
        return CommandExecutionResult.ok();
    }
}

