/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sprite;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.sprite.ColorPalette;
import znaishaded.net.sourceforge.plantuml.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.sprite.SpriteColor;

public class SpriteColorBuilder {
    private static final ColorPalette COLOR_PALETTE = new ColorPalette();

    public static Sprite buildSprite(List<CharSequence> strings) {
        SpriteColor result = new SpriteColor(strings.get(0).length(), strings.size());
        for (int col = 0; col < result.getWidth(); ++col) {
            for (int line = 0; line < result.getHeight(); ++line) {
                if (col >= strings.get(line).length()) continue;
                char charColor = strings.get(line).charAt(col);
                int idx = "0123456789ABCDEF".indexOf(charColor);
                if (idx != -1) {
                    result.setGrey(col, line, idx);
                    continue;
                }
                Color rgb = COLOR_PALETTE.getColorFor(charColor);
                result.setColor(col, line, rgb.getRGB() & 0xFFFFFF);
            }
        }
        return result;
    }

    public static List<String> encodeColor(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        ArrayList<String> result = new ArrayList<String>();
        for (int y = 0; y < height; ++y) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < width; ++x) {
                int rgb = img.getRGB(x, y) & 0xFFFFFF;
                char code = COLOR_PALETTE.getCharFor(new Color(rgb));
                sb.append(code);
            }
            result.add(sb.toString());
        }
        return Collections.unmodifiableList(result);
    }
}

