/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram.command;

import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Player;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingDiagram;

abstract class CommandChangeState
extends SingleLineCommand2<TimingDiagram> {
    static final String STATE_CODE = "([\\p{L}0-9_][\\p{L}0-9_.]*)";

    CommandChangeState(IRegex pattern) {
        super(pattern);
    }

    static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    protected CommandExecutionResult addState(TimingDiagram diagram, RegexResult arg, Player player, TimeTick now) {
        String comment = arg.get("COMMENT", 0);
        Colors colors = CommandChangeState.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        player.setState(now, comment, colors, this.getStates(arg));
        return CommandExecutionResult.ok();
    }

    private String[] getStates(RegexResult arg) {
        if (arg.get("STATE7", 0) != null) {
            String state1 = arg.get("STATE7", 0);
            String state2 = arg.get("STATE7", 1);
            return new String[]{state1, state2};
        }
        return new String[]{arg.getLazzy("STATE", 0)};
    }

    static IRegex getStateOrHidden() {
        return new RegexOr(new RegexLeaf("STATE1", "[%g]([^%g]*)[%g]"), new RegexLeaf("STATE2", STATE_CODE), new RegexLeaf("STATE3", "(\\{hidden\\})"), new RegexLeaf("STATE4", "(\\{\\.\\.\\.\\})"), new RegexLeaf("STATE5", "(\\{-\\})"), new RegexLeaf("STATE6", "(\\{\\?\\})"), new RegexLeaf("STATE7", "(?:\\{([\\p{L}0-9_][\\p{L}0-9_.]*),([\\p{L}0-9_][\\p{L}0-9_.]*)\\})"));
    }
}

