/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.color;

import java.awt.Color;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorChangerMonochrome;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorAbstract;

public class HColorSimple
extends HColorAbstract
implements HColor {
    private final Color color;
    private final boolean monochrome;

    public int hashCode() {
        return this.color.hashCode();
    }

    public String toString() {
        if (this.color.getAlpha() == 0) {
            return "transparent";
        }
        return this.color.toString() + " alpha=" + this.color.getAlpha() + " monochrome=" + this.monochrome;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HColorSimple)) {
            return false;
        }
        return this.color.equals(((HColorSimple)other).color);
    }

    public HColorSimple(Color c, boolean monochrome) {
        this.color = c;
        this.monochrome = monochrome;
    }

    public Color getColor999() {
        return this.color;
    }

    public HColorSimple asMonochrome() {
        if (this.monochrome) {
            throw new IllegalStateException();
        }
        return new HColorSimple(new ColorChangerMonochrome().getChangedColor(this.color), true);
    }

    public HColorSimple opposite() {
        Color mono = new ColorChangerMonochrome().getChangedColor(this.color);
        int grayScale = 255 - mono.getGreen() > 127 ? 255 : 0;
        return new HColorSimple(new Color(grayScale, grayScale, grayScale), true);
    }

    public double distance(HColorSimple other) {
        int diffRed = Math.abs(this.color.getRed() - other.color.getRed());
        int diffGreen = Math.abs(this.color.getGreen() - other.color.getGreen());
        int diffBlue = Math.abs(this.color.getBlue() - other.color.getBlue());
        return (double)diffRed * 0.3 + (double)diffGreen * 0.59 + (double)diffBlue * 0.11;
    }
}

