/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.wbs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Direction;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.mindmap.IdeaShape;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;

final class WElement {
    private final Display label;
    private final int level;
    private final String stereotype;
    private final WElement parent;
    private final StyleBuilder styleBuilder;
    private final List<WElement> childrenLeft = new ArrayList<WElement>();
    private final List<WElement> childrenRight = new ArrayList<WElement>();
    private final IdeaShape shape;

    private StyleSignature getDefaultStyleDefinitionNode(int level) {
        String depth = SName.depth(level);
        if (level == 0) {
            return StyleSignature.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.rootNode).add(this.stereotype).add(depth);
        }
        if (this.isLeaf()) {
            return StyleSignature.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.leafNode).add(this.stereotype).add(depth);
        }
        return StyleSignature.of(SName.root, SName.element, SName.wbsDiagram, SName.node).add(this.stereotype).add(depth);
    }

    public Style getStyle() {
        Style result = this.getDefaultStyleDefinitionNode(this.level).getMergedStyle(this.styleBuilder);
        WElement up = this.parent;
        while (up != null) {
            StyleSignature ss = up.getDefaultStyleDefinitionNode(this.level).addStar();
            Style p = ss.getMergedStyle(this.styleBuilder);
            result = result.mergeWith(p);
            up = up.parent;
        }
        return result;
    }

    public WElement(Display label, String stereotype, StyleBuilder styleBuilder) {
        this(0, label, stereotype, null, IdeaShape.BOX, styleBuilder);
    }

    private WElement(int level, Display label, String stereotype, WElement parent, IdeaShape shape, StyleBuilder styleBuilder) {
        this.label = label;
        this.level = level;
        this.parent = parent;
        this.shape = shape;
        this.styleBuilder = styleBuilder;
        this.stereotype = stereotype;
    }

    public boolean isLeaf() {
        return this.childrenLeft.size() == 0 && this.childrenRight.size() == 0;
    }

    public WElement createElement(int newLevel, Display newLabel, String stereotype, Direction direction, IdeaShape shape, StyleBuilder styleBuilder) {
        WElement result = new WElement(newLevel, newLabel, stereotype, this, shape, styleBuilder);
        if (direction == Direction.LEFT) {
            this.childrenLeft.add(result);
        } else {
            this.childrenRight.add(result);
        }
        return result;
    }

    public String toString() {
        return this.label.toString();
    }

    public final int getLevel() {
        return this.level;
    }

    public final Display getLabel() {
        return this.label;
    }

    public Collection<WElement> getChildren(Direction direction) {
        if (direction == Direction.LEFT) {
            return Collections.unmodifiableList(this.childrenLeft);
        }
        return Collections.unmodifiableList(this.childrenRight);
    }

    public WElement getParent() {
        return this.parent;
    }

    public final IdeaShape getShape() {
        return this.shape;
    }

    public final StyleBuilder getStyleBuilder() {
        return this.styleBuilder;
    }
}

