/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.webp;

import znaishaded.net.sourceforge.plantuml.webp.MacroBlock;
import znaishaded.net.sourceforge.plantuml.webp.Segment;
import znaishaded.net.sourceforge.plantuml.webp.SubBlock;
import znaishaded.net.sourceforge.plantuml.webp.VP8Frame;

public class LoopFilter {
    private static int abs(int v) {
        return v < 0 ? -v : v;
    }

    private static int c(int v) {
        int r = v;
        if (v < -128) {
            r = -128;
        }
        if (v > 127) {
            r = 127;
        }
        return r;
    }

    private static int common_adjust(boolean use_outer_taps, Segment seg) {
        int p1 = LoopFilter.u2s(seg.P1);
        int p0 = LoopFilter.u2s(seg.P0);
        int q0 = LoopFilter.u2s(seg.Q0);
        int q1 = LoopFilter.u2s(seg.Q1);
        int a = LoopFilter.c((use_outer_taps ? LoopFilter.c(p1 - q1) : 0) + 3 * (q0 - p0));
        int b = LoopFilter.c(a + 3) >> 3;
        a = LoopFilter.c(a + 4) >> 3;
        seg.Q0 = LoopFilter.s2u(q0 - a);
        seg.P0 = LoopFilter.s2u(p0 + b);
        return a;
    }

    public static boolean filter_yes(int I, int E, int p3, int p2, int p1, int p0, int q0, int q1, int q2, int q3) {
        return LoopFilter.abs(p0 - q0) * 2 + LoopFilter.abs(p1 - q1) / 2 <= E && LoopFilter.abs(p3 - p2) <= I && LoopFilter.abs(p2 - p1) <= I && LoopFilter.abs(p1 - p0) <= I && LoopFilter.abs(q3 - q2) <= I && LoopFilter.abs(q2 - q1) <= I && LoopFilter.abs(q1 - q0) <= I;
    }

    private static Segment getSegH(SubBlock rsb, SubBlock lsb, int a) {
        Segment seg = new Segment();
        int[][] rdest = rsb.getDest();
        int[][] ldest = lsb.getDest();
        seg.P0 = ldest[3][a];
        seg.P1 = ldest[2][a];
        seg.P2 = ldest[1][a];
        seg.P3 = ldest[0][a];
        seg.Q0 = rdest[0][a];
        seg.Q1 = rdest[1][a];
        seg.Q2 = rdest[2][a];
        seg.Q3 = rdest[3][a];
        return seg;
    }

    private static Segment getSegV(SubBlock bsb, SubBlock tsb, int a) {
        Segment seg = new Segment();
        int[][] bdest = bsb.getDest();
        int[][] tdest = tsb.getDest();
        seg.P0 = tdest[a][3];
        seg.P1 = tdest[a][2];
        seg.P2 = tdest[a][1];
        seg.P3 = tdest[a][0];
        seg.Q0 = bdest[a][0];
        seg.Q1 = bdest[a][1];
        seg.Q2 = bdest[a][2];
        seg.Q3 = bdest[a][3];
        return seg;
    }

    public static boolean hev(int threshold, int p1, int p0, int q0, int q1) {
        return LoopFilter.abs(p1 - p0) > threshold || LoopFilter.abs(q1 - q0) > threshold;
    }

    public static void loopFilter(VP8Frame frame) {
        frame.fireLFProgressUpdate(0.0f);
        if (frame.getFilterType() == 2) {
            LoopFilter.loopFilterUV(frame);
            frame.fireLFProgressUpdate(50.0f);
            LoopFilter.loopFilterY(frame);
        } else if (frame.getFilterType() == 1) {
            LoopFilter.loopFilterSimple(frame);
        }
        frame.fireLFProgressUpdate(100.0f);
    }

    public static void loopFilterSimple(VP8Frame frame) {
        for (int y = 0; y < frame.getMacroBlockRows(); ++y) {
            frame.fireLFProgressUpdate(100.0f * ((float)(y + 1) / (float)frame.getMacroBlockRows()));
            for (int x = 0; x < frame.getMacroBlockCols(); ++x) {
                SubBlock bsb;
                SubBlock tsb;
                int c;
                Segment seg;
                int a;
                int b;
                int sub_bedge_limit;
                MacroBlock rmb = frame.getMacroBlock(x, y);
                MacroBlock bmb = frame.getMacroBlock(x, y);
                int loop_filter_level = rmb.getFilterLevel();
                if (loop_filter_level == 0) continue;
                int interior_limit = rmb.getFilterLevel();
                int sharpnessLevel = frame.getSharpnessLevel();
                if (sharpnessLevel > 0 && (interior_limit >>= sharpnessLevel > 4 ? 2 : 1) > 9 - sharpnessLevel) {
                    interior_limit = 9 - sharpnessLevel;
                }
                if (interior_limit == 0) {
                    interior_limit = 1;
                }
                if ((sub_bedge_limit = loop_filter_level * 2 + interior_limit) < 1) {
                    sub_bedge_limit = 1;
                }
                int mbedge_limit = sub_bedge_limit + 4;
                if (x > 0) {
                    MacroBlock lmb = frame.getMacroBlock(x - 1, y);
                    for (b = 0; b < 4; ++b) {
                        SubBlock rsb = rmb.getSubBlock(SubBlock.PLANE.Y1, 0, b);
                        SubBlock lsb = lmb.getSubBlock(SubBlock.PLANE.Y1, 3, b);
                        for (a = 0; a < 4; ++a) {
                            seg = LoopFilter.getSegH(rsb, lsb, a);
                            LoopFilter.simple_segment(mbedge_limit, seg);
                            LoopFilter.setSegH(rsb, lsb, seg, a);
                        }
                    }
                }
                if (!rmb.isSkip_inner_lf()) {
                    for (int a2 = 1; a2 < 4; ++a2) {
                        for (b = 0; b < 4; ++b) {
                            SubBlock lsb = rmb.getSubBlock(SubBlock.PLANE.Y1, a2 - 1, b);
                            SubBlock rsb = rmb.getSubBlock(SubBlock.PLANE.Y1, a2, b);
                            for (c = 0; c < 4; ++c) {
                                seg = LoopFilter.getSegH(rsb, lsb, c);
                                LoopFilter.simple_segment(sub_bedge_limit, seg);
                                LoopFilter.setSegH(rsb, lsb, seg, c);
                            }
                        }
                    }
                }
                if (y > 0) {
                    MacroBlock tmb = frame.getMacroBlock(x, y - 1);
                    for (b = 0; b < 4; ++b) {
                        tsb = tmb.getSubBlock(SubBlock.PLANE.Y1, b, 3);
                        bsb = bmb.getSubBlock(SubBlock.PLANE.Y1, b, 0);
                        for (a = 0; a < 4; ++a) {
                            seg = LoopFilter.getSegV(bsb, tsb, a);
                            LoopFilter.simple_segment(mbedge_limit, seg);
                            LoopFilter.setSegV(bsb, tsb, seg, a);
                        }
                    }
                }
                if (rmb.isSkip_inner_lf()) continue;
                for (int a3 = 1; a3 < 4; ++a3) {
                    for (b = 0; b < 4; ++b) {
                        tsb = bmb.getSubBlock(SubBlock.PLANE.Y1, b, a3 - 1);
                        bsb = bmb.getSubBlock(SubBlock.PLANE.Y1, b, a3);
                        for (c = 0; c < 4; ++c) {
                            seg = LoopFilter.getSegV(bsb, tsb, c);
                            LoopFilter.simple_segment(sub_bedge_limit, seg);
                            LoopFilter.setSegV(bsb, tsb, seg, c);
                        }
                    }
                }
            }
        }
    }

    public static void loopFilterUV(VP8Frame frame) {
        for (int y = 0; y < frame.getMacroBlockRows(); ++y) {
            frame.fireLFProgressUpdate(100.0f * ((float)(y + 1) / (float)frame.getMacroBlockRows()) / 2.0f);
            for (int x = 0; x < frame.getMacroBlockCols(); ++x) {
                SubBlock bsbV;
                SubBlock tsbV;
                SubBlock bsbU;
                SubBlock tsbU;
                int c;
                Segment seg;
                int a;
                int b;
                MacroBlock rmb = frame.getMacroBlock(x, y);
                MacroBlock bmb = frame.getMacroBlock(x, y);
                int sharpnessLevel = frame.getSharpnessLevel();
                int loop_filter_level = rmb.getFilterLevel();
                if (loop_filter_level == 0) continue;
                int interior_limit = rmb.getFilterLevel();
                if (sharpnessLevel > 0 && (interior_limit >>= sharpnessLevel > 4 ? 2 : 1) > 9 - sharpnessLevel) {
                    interior_limit = 9 - sharpnessLevel;
                }
                if (interior_limit == 0) {
                    interior_limit = 1;
                }
                int hev_threshold = 0;
                if (frame.getFrameType() == 0) {
                    if (loop_filter_level >= 40) {
                        hev_threshold = 2;
                    } else if (loop_filter_level >= 15) {
                        hev_threshold = 1;
                    }
                } else if (loop_filter_level >= 40) {
                    hev_threshold = 3;
                } else if (loop_filter_level >= 20) {
                    hev_threshold = 2;
                } else if (loop_filter_level >= 15) {
                    hev_threshold = 1;
                }
                int mbedge_limit = (loop_filter_level + 2) * 2 + interior_limit;
                int sub_bedge_limit = loop_filter_level * 2 + interior_limit;
                if (x > 0) {
                    MacroBlock lmb = frame.getMacroBlock(x - 1, y);
                    for (b = 0; b < 2; ++b) {
                        SubBlock rsbU = rmb.getSubBlock(SubBlock.PLANE.U, 0, b);
                        SubBlock lsbU = lmb.getSubBlock(SubBlock.PLANE.U, 1, b);
                        SubBlock rsbV = rmb.getSubBlock(SubBlock.PLANE.V, 0, b);
                        SubBlock lsbV = lmb.getSubBlock(SubBlock.PLANE.V, 1, b);
                        for (a = 0; a < 4; ++a) {
                            seg = LoopFilter.getSegH(rsbU, lsbU, a);
                            LoopFilter.MBfilter(hev_threshold, interior_limit, mbedge_limit, seg);
                            LoopFilter.setSegH(rsbU, lsbU, seg, a);
                            seg = LoopFilter.getSegH(rsbV, lsbV, a);
                            LoopFilter.MBfilter(hev_threshold, interior_limit, mbedge_limit, seg);
                            LoopFilter.setSegH(rsbV, lsbV, seg, a);
                        }
                    }
                }
                if (!rmb.isSkip_inner_lf()) {
                    for (int a2 = 1; a2 < 2; ++a2) {
                        for (b = 0; b < 2; ++b) {
                            SubBlock lsbU = rmb.getSubBlock(SubBlock.PLANE.U, a2 - 1, b);
                            SubBlock rsbU = rmb.getSubBlock(SubBlock.PLANE.U, a2, b);
                            SubBlock lsbV = rmb.getSubBlock(SubBlock.PLANE.V, a2 - 1, b);
                            SubBlock rsbV = rmb.getSubBlock(SubBlock.PLANE.V, a2, b);
                            for (c = 0; c < 4; ++c) {
                                seg = LoopFilter.getSegH(rsbU, lsbU, c);
                                LoopFilter.subblock_filter(hev_threshold, interior_limit, sub_bedge_limit, seg);
                                LoopFilter.setSegH(rsbU, lsbU, seg, c);
                                seg = LoopFilter.getSegH(rsbV, lsbV, c);
                                LoopFilter.subblock_filter(hev_threshold, interior_limit, sub_bedge_limit, seg);
                                LoopFilter.setSegH(rsbV, lsbV, seg, c);
                            }
                        }
                    }
                }
                if (y > 0) {
                    MacroBlock tmb = frame.getMacroBlock(x, y - 1);
                    for (b = 0; b < 2; ++b) {
                        tsbU = tmb.getSubBlock(SubBlock.PLANE.U, b, 1);
                        bsbU = bmb.getSubBlock(SubBlock.PLANE.U, b, 0);
                        tsbV = tmb.getSubBlock(SubBlock.PLANE.V, b, 1);
                        bsbV = bmb.getSubBlock(SubBlock.PLANE.V, b, 0);
                        for (a = 0; a < 4; ++a) {
                            seg = LoopFilter.getSegV(bsbU, tsbU, a);
                            LoopFilter.MBfilter(hev_threshold, interior_limit, mbedge_limit, seg);
                            LoopFilter.setSegV(bsbU, tsbU, seg, a);
                            seg = LoopFilter.getSegV(bsbV, tsbV, a);
                            LoopFilter.MBfilter(hev_threshold, interior_limit, mbedge_limit, seg);
                            LoopFilter.setSegV(bsbV, tsbV, seg, a);
                        }
                    }
                }
                if (rmb.isSkip_inner_lf()) continue;
                for (int a3 = 1; a3 < 2; ++a3) {
                    for (b = 0; b < 2; ++b) {
                        tsbU = bmb.getSubBlock(SubBlock.PLANE.U, b, a3 - 1);
                        bsbU = bmb.getSubBlock(SubBlock.PLANE.U, b, a3);
                        tsbV = bmb.getSubBlock(SubBlock.PLANE.V, b, a3 - 1);
                        bsbV = bmb.getSubBlock(SubBlock.PLANE.V, b, a3);
                        for (c = 0; c < 4; ++c) {
                            seg = LoopFilter.getSegV(bsbU, tsbU, c);
                            LoopFilter.subblock_filter(hev_threshold, interior_limit, sub_bedge_limit, seg);
                            LoopFilter.setSegV(bsbU, tsbU, seg, c);
                            seg = LoopFilter.getSegV(bsbV, tsbV, c);
                            LoopFilter.subblock_filter(hev_threshold, interior_limit, sub_bedge_limit, seg);
                            LoopFilter.setSegV(bsbV, tsbV, seg, c);
                        }
                    }
                }
            }
        }
    }

    public static void loopFilterY(VP8Frame frame) {
        for (int y = 0; y < frame.getMacroBlockRows(); ++y) {
            frame.fireLFProgressUpdate(50.0f + 100.0f * ((float)(y + 1) / (float)frame.getMacroBlockRows()) / 2.0f);
            for (int x = 0; x < frame.getMacroBlockCols(); ++x) {
                SubBlock bsb;
                SubBlock tsb;
                int c;
                Segment seg;
                int a;
                int b;
                MacroBlock rmb = frame.getMacroBlock(x, y);
                MacroBlock bmb = frame.getMacroBlock(x, y);
                int sharpnessLevel = frame.getSharpnessLevel();
                int loop_filter_level = rmb.getFilterLevel();
                if (loop_filter_level == 0) continue;
                int interior_limit = rmb.getFilterLevel();
                if (sharpnessLevel > 0 && (interior_limit >>= sharpnessLevel > 4 ? 2 : 1) > 9 - sharpnessLevel) {
                    interior_limit = 9 - sharpnessLevel;
                }
                if (interior_limit == 0) {
                    interior_limit = 1;
                }
                int hev_threshold = 0;
                if (frame.getFrameType() == 0) {
                    if (loop_filter_level >= 40) {
                        hev_threshold = 2;
                    } else if (loop_filter_level >= 15) {
                        hev_threshold = 1;
                    }
                } else if (loop_filter_level >= 40) {
                    hev_threshold = 3;
                } else if (loop_filter_level >= 20) {
                    hev_threshold = 2;
                } else if (loop_filter_level >= 15) {
                    hev_threshold = 1;
                }
                int mbedge_limit = (loop_filter_level + 2) * 2 + interior_limit;
                int sub_bedge_limit = loop_filter_level * 2 + interior_limit;
                if (x > 0) {
                    MacroBlock lmb = frame.getMacroBlock(x - 1, y);
                    for (b = 0; b < 4; ++b) {
                        SubBlock rsb = rmb.getSubBlock(SubBlock.PLANE.Y1, 0, b);
                        SubBlock lsb = lmb.getSubBlock(SubBlock.PLANE.Y1, 3, b);
                        for (a = 0; a < 4; ++a) {
                            seg = LoopFilter.getSegH(rsb, lsb, a);
                            LoopFilter.MBfilter(hev_threshold, interior_limit, mbedge_limit, seg);
                            LoopFilter.setSegH(rsb, lsb, seg, a);
                        }
                    }
                }
                if (!rmb.isSkip_inner_lf()) {
                    for (int a2 = 1; a2 < 4; ++a2) {
                        for (b = 0; b < 4; ++b) {
                            SubBlock lsb = rmb.getSubBlock(SubBlock.PLANE.Y1, a2 - 1, b);
                            SubBlock rsb = rmb.getSubBlock(SubBlock.PLANE.Y1, a2, b);
                            for (c = 0; c < 4; ++c) {
                                seg = LoopFilter.getSegH(rsb, lsb, c);
                                LoopFilter.subblock_filter(hev_threshold, interior_limit, sub_bedge_limit, seg);
                                LoopFilter.setSegH(rsb, lsb, seg, c);
                            }
                        }
                    }
                }
                if (y > 0) {
                    MacroBlock tmb = frame.getMacroBlock(x, y - 1);
                    for (b = 0; b < 4; ++b) {
                        tsb = tmb.getSubBlock(SubBlock.PLANE.Y1, b, 3);
                        bsb = bmb.getSubBlock(SubBlock.PLANE.Y1, b, 0);
                        for (a = 0; a < 4; ++a) {
                            seg = LoopFilter.getSegV(bsb, tsb, a);
                            LoopFilter.MBfilter(hev_threshold, interior_limit, mbedge_limit, seg);
                            LoopFilter.setSegV(bsb, tsb, seg, a);
                        }
                    }
                }
                if (rmb.isSkip_inner_lf()) continue;
                for (int a3 = 1; a3 < 4; ++a3) {
                    for (b = 0; b < 4; ++b) {
                        tsb = bmb.getSubBlock(SubBlock.PLANE.Y1, b, a3 - 1);
                        bsb = bmb.getSubBlock(SubBlock.PLANE.Y1, b, a3);
                        for (c = 0; c < 4; ++c) {
                            seg = LoopFilter.getSegV(bsb, tsb, c);
                            LoopFilter.subblock_filter(hev_threshold, interior_limit, sub_bedge_limit, seg);
                            LoopFilter.setSegV(bsb, tsb, seg, c);
                        }
                    }
                }
            }
        }
    }

    static void MBfilter(int hev_threshold, int interior_limit, int edge_limit, Segment seg) {
        int p3 = LoopFilter.u2s(seg.P3);
        int p2 = LoopFilter.u2s(seg.P2);
        int p1 = LoopFilter.u2s(seg.P1);
        int p0 = LoopFilter.u2s(seg.P0);
        int q0 = LoopFilter.u2s(seg.Q0);
        int q1 = LoopFilter.u2s(seg.Q1);
        int q2 = LoopFilter.u2s(seg.Q2);
        int q3 = LoopFilter.u2s(seg.Q3);
        if (LoopFilter.filter_yes(interior_limit, edge_limit, q3, q2, q1, q0, p0, p1, p2, p3)) {
            if (!LoopFilter.hev(hev_threshold, p1, p0, q0, q1)) {
                int w = LoopFilter.c(LoopFilter.c(p1 - q1) + 3 * (q0 - p0));
                int a = 27 * w + 63 >> 7;
                seg.Q0 = LoopFilter.s2u(q0 - a);
                seg.P0 = LoopFilter.s2u(p0 + a);
                a = 18 * w + 63 >> 7;
                seg.Q1 = LoopFilter.s2u(q1 - a);
                seg.P1 = LoopFilter.s2u(p1 + a);
                a = 9 * w + 63 >> 7;
                seg.Q2 = LoopFilter.s2u(q2 - a);
                seg.P2 = LoopFilter.s2u(p2 + a);
            } else {
                LoopFilter.common_adjust(true, seg);
            }
        }
    }

    private static int s2u(int v) {
        return LoopFilter.c(v) + 128;
    }

    private static void setSegH(SubBlock rsb, SubBlock lsb, Segment seg, int a) {
        int[][] rdest = rsb.getDest();
        int[][] ldest = lsb.getDest();
        ldest[3][a] = seg.P0;
        ldest[2][a] = seg.P1;
        ldest[1][a] = seg.P2;
        ldest[0][a] = seg.P3;
        rdest[0][a] = seg.Q0;
        rdest[1][a] = seg.Q1;
        rdest[2][a] = seg.Q2;
        rdest[3][a] = seg.Q3;
    }

    private static void setSegV(SubBlock bsb, SubBlock tsb, Segment seg, int a) {
        int[][] bdest = bsb.getDest();
        int[][] tdest = tsb.getDest();
        tdest[a][3] = seg.P0;
        tdest[a][2] = seg.P1;
        tdest[a][1] = seg.P2;
        tdest[a][0] = seg.P3;
        bdest[a][0] = seg.Q0;
        bdest[a][1] = seg.Q1;
        bdest[a][2] = seg.Q2;
        bdest[a][3] = seg.Q3;
    }

    private static void simple_segment(int edge_limit, Segment seg) {
        if (LoopFilter.abs(seg.P0 - seg.Q0) * 2 + LoopFilter.abs(seg.P1 - seg.Q1) / 2 <= edge_limit) {
            LoopFilter.common_adjust(true, seg);
        }
    }

    public static void subblock_filter(int hev_threshold, int interior_limit, int edge_limit, Segment seg) {
        int p3 = LoopFilter.u2s(seg.P3);
        int p2 = LoopFilter.u2s(seg.P2);
        int p1 = LoopFilter.u2s(seg.P1);
        int p0 = LoopFilter.u2s(seg.P0);
        int q0 = LoopFilter.u2s(seg.Q0);
        int q1 = LoopFilter.u2s(seg.Q1);
        int q2 = LoopFilter.u2s(seg.Q2);
        int q3 = LoopFilter.u2s(seg.Q3);
        if (LoopFilter.filter_yes(interior_limit, edge_limit, q3, q2, q1, q0, p0, p1, p2, p3)) {
            boolean hv = LoopFilter.hev(hev_threshold, p1, p0, q0, q1);
            int a = LoopFilter.common_adjust(hv, seg) + 1 >> 1;
            if (!hv) {
                seg.Q1 = LoopFilter.s2u(q1 - a);
                seg.P1 = LoopFilter.s2u(p1 + a);
            }
        }
    }

    private static int u2s(int v) {
        return v - 128;
    }
}

