/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.ant.compress.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import znaishaded.org.apache.ant.compress.resources.ZipFileSet;
import znaishaded.org.apache.ant.compress.taskdefs.ArchiveBase;
import znaishaded.org.apache.ant.compress.util.ZipStreamFactory;
import znaishaded.org.apache.commons.compress.archivers.ArchiveEntry;
import znaishaded.org.apache.commons.compress.archivers.ArchiveOutputStream;
import znaishaded.org.apache.commons.compress.archivers.zip.Zip64Mode;
import znaishaded.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import znaishaded.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import znaishaded.org.apache.tools.ant.types.ArchiveFileSet;
import znaishaded.org.apache.tools.ant.types.EnumeratedAttribute;
import znaishaded.org.apache.tools.ant.types.Resource;

public class Zip
extends ArchiveBase {
    private int level = -1;
    private String comment = "";
    private boolean keepCompression = false;
    private boolean fallBackToUTF8 = false;
    private boolean useLanguageEncodingFlag = true;
    private UnicodeExtraField createUnicodeExtraFields = UnicodeExtraField.NEVER;
    private Zip64Enum zip64Mode = Zip64Enum.AS_NEEDED;

    public Zip() {
        this.setFactory(new ZipStreamFactory(){

            @Override
            public ArchiveOutputStream getArchiveStream(OutputStream stream, String encoding) throws IOException {
                ZipArchiveOutputStream o = (ZipArchiveOutputStream)super.getArchiveStream(stream, encoding);
                Zip.this.configure(o);
                return o;
            }

            @Override
            public ArchiveOutputStream getArchiveOutputStream(File f, String encoding) throws IOException {
                ZipArchiveOutputStream o = (ZipArchiveOutputStream)super.getArchiveOutputStream(f, encoding);
                Zip.this.configure(o);
                return o;
            }
        });
        this.setEntryBuilder(new ArchiveBase.EntryBuilder(){

            @Override
            public ArchiveEntry buildEntry(ArchiveBase.ResourceWithFlags r) {
                boolean isDir = r.getResource().isDirectory();
                ZipArchiveEntry ent = new ZipArchiveEntry(r.getName());
                ent.setTime(Zip.this.round(r.getResource().getLastModified(), 2000L));
                ent.setSize(isDir ? 0L : r.getResource().getSize());
                if (!isDir && r.getCollectionFlags().hasModeBeenSet()) {
                    ent.setUnixMode(r.getCollectionFlags().getMode());
                } else if (isDir && r.getCollectionFlags().hasDirModeBeenSet()) {
                    ent.setUnixMode(r.getCollectionFlags().getDirMode());
                } else if (r.getResourceFlags().hasModeBeenSet()) {
                    ent.setUnixMode(r.getResourceFlags().getMode());
                } else {
                    ent.setUnixMode(isDir ? 16877 : 33188);
                }
                if (r.getResourceFlags().getZipExtraFields() != null) {
                    ent.setExtraFields(r.getResourceFlags().getZipExtraFields());
                }
                if (Zip.this.keepCompression && r.getResourceFlags().hasCompressionMethod()) {
                    ent.setMethod(r.getResourceFlags().getCompressionMethod());
                }
                return ent;
            }
        });
        this.setFileSetBuilder(new ArchiveBase.FileSetBuilder(){

            @Override
            public ArchiveFileSet buildFileSet(Resource dest) {
                ZipFileSet afs = new ZipFileSet();
                afs.setSrcResource(dest);
                return afs;
            }
        });
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setKeepCompression(boolean keep) {
        this.keepCompression = keep;
    }

    public void setFallBackToUTF8(boolean b) {
        this.fallBackToUTF8 = b;
    }

    public void setUseLanguageEncodingFlag(boolean b) {
        this.useLanguageEncodingFlag = b;
    }

    public void setCreateUnicodeExtraFields(UnicodeExtraField b) {
        this.createUnicodeExtraFields = b;
    }

    public void setZip64Mode(Zip64Enum mode) {
        this.zip64Mode = mode;
    }

    private void configure(ZipArchiveOutputStream o) {
        o.setLevel(this.level);
        o.setComment(this.comment);
        o.setFallbackToUTF8(this.fallBackToUTF8);
        o.setUseLanguageEncodingFlag(this.useLanguageEncodingFlag);
        o.setCreateUnicodeExtraFields(this.createUnicodeExtraFields.getPolicy());
        o.setUseZip64(this.zip64Mode.getPolicy());
    }

    public static final class Zip64Enum
    extends EnumeratedAttribute {
        private static final Map POLICIES = new HashMap();
        private static final String NEVER_KEY = "never";
        private static final String ALWAYS_KEY = "always";
        private static final String A_N_KEY = "as-needed";
        public static final Zip64Enum AS_NEEDED;

        @Override
        public String[] getValues() {
            return new String[]{NEVER_KEY, ALWAYS_KEY, A_N_KEY};
        }

        private Zip64Enum(String name) {
            this.setValue(name);
        }

        public Zip64Enum() {
        }

        public Zip64Mode getPolicy() {
            return (Zip64Mode)((Object)POLICIES.get(this.getValue()));
        }

        static {
            POLICIES.put(NEVER_KEY, Zip64Mode.Never);
            POLICIES.put(ALWAYS_KEY, Zip64Mode.Always);
            POLICIES.put(A_N_KEY, Zip64Mode.AsNeeded);
            AS_NEEDED = new Zip64Enum(A_N_KEY);
        }
    }

    public static final class UnicodeExtraField
    extends EnumeratedAttribute {
        private static final Map POLICIES = new HashMap();
        private static final String NEVER_KEY = "never";
        private static final String ALWAYS_KEY = "always";
        private static final String N_E_KEY = "not-encodeable";
        public static final UnicodeExtraField NEVER;

        @Override
        public String[] getValues() {
            return new String[]{NEVER_KEY, ALWAYS_KEY, N_E_KEY};
        }

        private UnicodeExtraField(String name) {
            this.setValue(name);
        }

        public UnicodeExtraField() {
        }

        public ZipArchiveOutputStream.UnicodeExtraFieldPolicy getPolicy() {
            return (ZipArchiveOutputStream.UnicodeExtraFieldPolicy)POLICIES.get(this.getValue());
        }

        static {
            POLICIES.put(NEVER_KEY, ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NEVER);
            POLICIES.put(ALWAYS_KEY, ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
            POLICIES.put(N_E_KEY, ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
            NEVER = new UnicodeExtraField(NEVER_KEY);
        }
    }
}

